/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.client.render.tile;

import assemblyline.client.AssemblyLineClientRegister;
import assemblyline.common.tile.belt.TileSorterBelt;
import assemblyline.common.tile.belt.utils.ConveyorType;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.MathUtils;

public class RenderSorterBelt
extends AbstractTileRenderer<TileSorterBelt> {
    public RenderSorterBelt(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(@NotNull TileSorterBelt tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ComponentInventory inv = (ComponentInventory)tile.getComponent(IComponentType.Inventory);
        ItemStack stack = inv.getItem(0);
        ConveyorType type = tile.getConveyorType();
        matrixStackIn.pushPose();
        if (!stack.isEmpty()) {
            Vector3f itemVec = tile.getLocalItemLocationVector();
            Vector3f move = tile.getDirectionVector();
            Direction direct = tile.getDirectionForNext();
            if (type != ConveyorType.HORIZONTAL) {
                move = move.add(0.0f, type == ConveyorType.SLOPED_DOWN ? -1.0f : 1.0f, 0.0f);
            }
            move = move.mul(0.0625f);
            if (((Boolean)tile.running.getValue()).booleanValue()) {
                itemVec = itemVec.add((Vector3fc)move);
            }
            boolean blockItem = stack.getItem() instanceof BlockItem;
            switch (type) {
                case HORIZONTAL: {
                    matrixStackIn.translate((double)itemVec.x(), (double)itemVec.y() + (blockItem ? 0.167 : 0.3125) + (double)move.y(), (double)itemVec.z());
                    matrixStackIn.scale(0.35f, 0.35f, 0.35f);
                    matrixStackIn.translate(0.0f, 0.89285713f, 0.0f);
                    if (!blockItem) {
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)90.0f, (Vector3f)MathUtils.XN));
                    }
                    if (direct != Direction.EAST && direct != Direction.WEST) break;
                    matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)90.0f, (Vector3f)MathUtils.YN));
                    break;
                }
                case SLOPED_DOWN: {
                    matrixStackIn.translate((double)itemVec.x(), (double)itemVec.y() + (blockItem ? 0.167 : 0.125), (double)itemVec.z());
                    matrixStackIn.scale(0.35f, 0.35f, 0.35f);
                    if (!blockItem) {
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)90.0f, (Vector3f)MathUtils.XN));
                    }
                    int rotate = -45;
                    if (direct == Direction.NORTH) {
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)180.0f, (Vector3f)MathUtils.YP));
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)rotate, (Vector3f)MathUtils.XN));
                    } else if (direct == Direction.EAST) {
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)90.0f, (Vector3f)MathUtils.YP));
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)(-rotate), (Vector3f)MathUtils.XP));
                    } else if (direct == Direction.WEST) {
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)-90.0f, (Vector3f)MathUtils.YP));
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)rotate, (Vector3f)MathUtils.XN));
                    } else if (direct == Direction.SOUTH) {
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)(-rotate), (Vector3f)MathUtils.XP));
                    }
                    matrixStackIn.translate(0.0f, 0.35714287f, 0.0f);
                    break;
                }
                case SLOPED_UP: {
                    matrixStackIn.translate((double)itemVec.x(), (double)itemVec.y() + (blockItem ? 0.167 : 0.4375), (double)itemVec.z());
                    matrixStackIn.scale(0.35f, 0.35f, 0.35f);
                    if (!blockItem) {
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)90.0f, (Vector3f)MathUtils.XN));
                    }
                    int rotate = 45;
                    if (direct == Direction.NORTH) {
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)180.0f, (Vector3f)MathUtils.YP));
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)rotate, (Vector3f)MathUtils.XN));
                    } else if (direct == Direction.EAST) {
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)90.0f, (Vector3f)MathUtils.YP));
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)(-rotate), (Vector3f)MathUtils.XP));
                    } else if (direct == Direction.WEST) {
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)-90.0f, (Vector3f)MathUtils.YP));
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)rotate, (Vector3f)MathUtils.XN));
                    } else if (direct == Direction.SOUTH) {
                        matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)(-rotate), (Vector3f)MathUtils.XP));
                    }
                    matrixStackIn.translate(0.0f, 0.89285713f, 0.0f);
                    break;
                }
                case VERTICAL: {
                    matrixStackIn.translate(0.5, (double)itemVec.y() + (blockItem ? 0.167 : 0.3125) + 0.3125, 0.5);
                    matrixStackIn.scale(0.35f, 0.35f, 0.35f);
                    if (blockItem) break;
                    matrixStackIn.mulPose(MathUtils.rotVectorQuaternionDeg((float)90.0f, (Vector3f)MathUtils.XN));
                    break;
                }
            }
            this.minecraft().getItemRenderer().renderStatic(stack, ItemDisplayContext.NONE, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, tile.getLevel(), 0);
        }
        matrixStackIn.popPose();
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0, 0.0625, 0.0);
        RenderingUtils.prepareRotationalTileModel((BlockEntity)tile, (PoseStack)matrixStackIn);
        RenderingUtils.renderModel((BakedModel)this.getModel((Boolean)tile.running.getValue() != false ? AssemblyLineClientRegister.MODEL_SORTERBELT_RUNNING : AssemblyLineClientRegister.MODEL_SORTERBELT), (BlockEntity)tile, (RenderType)RenderType.solid(), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
        matrixStackIn.popPose();
    }
}

