/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.client.screen;

import assemblyline.client.event.levelstage.HandlerHarvesterLines;
import assemblyline.client.screen.generic.GenericOutlineAreaScreen;
import assemblyline.common.inventory.container.ContainerBlockBreaker;
import assemblyline.common.settings.AssemblyLineConfig;
import assemblyline.common.tile.TileBlockBreaker;
import assemblyline.prefab.utils.AssemblyTextUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.types.ScreenComponentCountdown;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;

public class ScreenBlockBreaker
extends GenericOutlineAreaScreen<ContainerBlockBreaker> {
    public ScreenBlockBreaker(ContainerBlockBreaker screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.addComponent((AbstractScreenComponent)new ScreenComponentCountdown(this::getTooltip, () -> {
            TileBlockBreaker breaker = (TileBlockBreaker)((ContainerBlockBreaker)this.menu).getSafeHost();
            if (breaker != null) {
                return (double)((Integer)breaker.ticksSinceCheck.getValue()).intValue() / (double)((Integer)breaker.currentWaitTime.getValue()).intValue();
            }
            return 0.0;
        }, 10, 50));
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(this::getElectricInformation, -25, 2));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(10, 20, 60, 20).setLabel(() -> {
            TileBlockBreaker harvester = (TileBlockBreaker)((ContainerBlockBreaker)this.menu).getSafeHost();
            if (harvester != null) {
                return HandlerHarvesterLines.containsLines(harvester.getBlockPos()) ? AssemblyTextUtils.gui("hidearea", new Object[0]) : AssemblyTextUtils.gui("renderarea", new Object[0]);
            }
            return Component.empty();
        }).setOnPress(button -> this.toggleRendering()));
    }

    private List<? extends FormattedCharSequence> getElectricInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        TileBlockBreaker harvester = (TileBlockBreaker)((ContainerBlockBreaker)this.menu).getSafeHost();
        if (harvester != null) {
            ComponentElectrodynamic electro = (ComponentElectrodynamic)harvester.getComponent(IComponentType.Electrodynamic);
            list.add(AssemblyTextUtils.gui("machine.usage", ChatFormatter.getChatDisplayShort((double)(AssemblyLineConfig.INSTANCE.BLOCKBREAKER_USAGE.getAsDouble() * 20.0), (IDisplayUnit)DisplayUnits.WATT)).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.DARK_GRAY).getVisualOrderText());
            list.add(AssemblyTextUtils.gui("machine.voltage", ChatFormatter.getChatDisplayShort((double)electro.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE)).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.DARK_GRAY).getVisualOrderText());
        }
        return list;
    }

    @Override
    public boolean isFlipped() {
        return true;
    }

    protected List<? extends FormattedCharSequence> getTooltip() {
        ArrayList<FormattedCharSequence> tips = new ArrayList<FormattedCharSequence>();
        TileBlockBreaker breaker = (TileBlockBreaker)((ContainerBlockBreaker)this.menu).getSafeHost();
        if (breaker != null) {
            tips.add(AssemblyTextUtils.tooltip("breakingprogress", ChatFormatter.getChatDisplayShort((double)(100.0 * (double)((Integer)breaker.ticksSinceCheck.getValue()).intValue() / (double)((Integer)breaker.currentWaitTime.getValue()).intValue()), (IDisplayUnit)DisplayUnits.PERCENTAGE)).withStyle(ChatFormatting.GRAY).getVisualOrderText());
        }
        return tips;
    }
}

