/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.client.screen;

import assemblyline.client.event.levelstage.HandlerFarmerLines;
import assemblyline.common.inventory.container.ContainerFarmer;
import assemblyline.common.settings.AssemblyLineConfig;
import assemblyline.common.tile.TileFarmer;
import assemblyline.prefab.utils.AssemblyTextUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.phys.AABB;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.types.ScreenComponentCountdown;
import voltaic.prefab.screen.component.types.ScreenComponentSlot;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.types.wrapper.WrapperInventoryIO;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.utilities.math.Color;

public class ScreenFarmer
extends GenericScreen<ContainerFarmer> {
    public static final Color[] COLORS = new Color[]{new Color(50, 50, 50, 255), new Color(255, 0, 0, 255), new Color(120, 0, 255, 255), new Color(0, 240, 0, 255), new Color(220, 0, 255, 255), new Color(255, 120, 0, 255), new Color(0, 0, 255, 255), new Color(240, 255, 0, 255), new Color(0, 240, 255, 255)};
    public ScreenComponentButton<?> renderArea;
    public ScreenComponentButton<?> fullBonemeal;
    public ScreenComponentButton<?> refillEmpty;

    public ScreenFarmer(ContainerFarmer container, Inventory inv, Component titleIn) {
        super((GenericContainer)container, inv, titleIn);
        this.imageHeight += 58;
        this.inventoryLabelY += 58;
        this.addComponent((AbstractScreenComponent)new ScreenComponentCountdown(() -> {
            TileFarmer farmer = (TileFarmer)((ContainerFarmer)this.menu).getSafeHost();
            if (farmer != null) {
                return 1.0f - (float)((Integer)farmer.ticksSinceCheck.getValue()).intValue() / Math.max((float)((Integer)farmer.currentWaitTime.getValue()).intValue(), 1.0f);
            }
            return 0.0;
        }, 10, 108));
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(this::getElectricInformation, -25, 2));
        this.fullBonemeal = new ScreenComponentButton(10, 20, 60, 20).setLabel(() -> {
            TileFarmer farmer = (TileFarmer)((ContainerFarmer)this.menu).getSafeHost();
            if (farmer == null) {
                return Component.empty();
            }
            return (Boolean)farmer.fullGrowBonemeal.getValue() != false ? AssemblyTextUtils.gui("regbonemeal", new Object[0]) : AssemblyTextUtils.gui("fullbonemeal", new Object[0]);
        }).setOnPress(button -> {
            TileFarmer farmer = (TileFarmer)((ContainerFarmer)this.menu).getSafeHost();
            if (farmer == null) {
                return;
            }
            farmer.fullGrowBonemeal.setValue((Object)((Boolean)farmer.fullGrowBonemeal.getValue() == false ? 1 : 0));
        });
        this.addComponent((AbstractScreenComponent)this.fullBonemeal);
        this.refillEmpty = new ScreenComponentButton(10, 50, 60, 20).setLabel(() -> {
            TileFarmer farmer = (TileFarmer)((ContainerFarmer)this.menu).getSafeHost();
            if (farmer == null) {
                return Component.empty();
            }
            return (Boolean)farmer.refillEmpty.getValue() != false ? AssemblyTextUtils.gui("ignoreempty", new Object[0]) : AssemblyTextUtils.gui("refillempty", new Object[0]);
        }).setOnPress(button -> {
            TileFarmer farmer = (TileFarmer)((ContainerFarmer)this.menu).getSafeHost();
            if (farmer == null) {
                return;
            }
            farmer.refillEmpty.setValue((Object)((Boolean)farmer.refillEmpty.getValue() == false ? 1 : 0));
        });
        this.addComponent((AbstractScreenComponent)this.refillEmpty);
        this.renderArea = new ScreenComponentButton(10, 80, 60, 20).setLabel(() -> {
            TileFarmer farmer = (TileFarmer)((ContainerFarmer)this.menu).getSafeHost();
            if (farmer == null) {
                return Component.empty();
            }
            return HandlerFarmerLines.isBeingRendered(farmer.getBlockPos()) ? AssemblyTextUtils.gui("hidearea", new Object[0]) : AssemblyTextUtils.gui("renderarea", new Object[0]);
        }).setOnPress(button -> {
            TileFarmer farmer = (TileFarmer)((ContainerFarmer)this.menu).getSafeHost();
            if (farmer != null) {
                BlockPos pos = farmer.getBlockPos();
                if (HandlerFarmerLines.isBeingRendered(pos)) {
                    HandlerFarmerLines.remove(pos);
                } else {
                    ScreenFarmer.updateBox(farmer);
                }
            }
        });
        this.addComponent((AbstractScreenComponent)this.renderArea);
        new WrapperInventoryIO((GenericScreen)this, -25, 28, 75, 140, 8, 130, (slot, index) -> {
            if (index < 9) {
                return COLORS[index];
            }
            return Color.WHITE;
        });
    }

    private List<? extends FormattedCharSequence> getElectricInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        TileFarmer farmer = (TileFarmer)((ContainerFarmer)this.menu).getSafeHost();
        if (farmer != null) {
            ComponentElectrodynamic electro = (ComponentElectrodynamic)farmer.getComponent(IComponentType.Electrodynamic);
            list.add(AssemblyTextUtils.gui("machine.usage", ChatFormatter.getChatDisplayShort((double)(AssemblyLineConfig.INSTANCE.FARMER_USAGE.getAsDouble() * (Double)farmer.powerUsageMultiplier.getValue() * 20.0), (IDisplayUnit)DisplayUnits.WATT).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY).getVisualOrderText());
            list.add(AssemblyTextUtils.gui("machine.voltage", ChatFormatter.getChatDisplayShort((double)electro.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY).getVisualOrderText());
        }
        return list;
    }

    protected void containerTick() {
        super.containerTick();
        TileFarmer farmer = (TileFarmer)((ContainerFarmer)this.menu).getSafeHost();
        if (farmer != null && HandlerFarmerLines.isBeingRendered(farmer.getBlockPos())) {
            HandlerFarmerLines.remove(farmer.getBlockPos());
            ScreenFarmer.updateBox(farmer);
        }
    }

    protected ScreenComponentSlot createScreenSlot(Slot slot) {
        ScreenComponentSlot component = super.createScreenSlot(slot);
        int index = slot.index;
        if (index < 9) {
            component.setColor(COLORS[index]);
        }
        return component;
    }

    private static void updateBox(TileFarmer farmer) {
        HandlerFarmerLines.addRenderData(farmer.getBlockPos(), (Pair<Color[], List<AABB>>)Pair.of((Object)COLORS, farmer.getLines(farmer)));
    }
}

