/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.client.screen;

import assemblyline.client.event.levelstage.HandlerHarvesterLines;
import assemblyline.client.screen.generic.GenericOutlineAreaScreen;
import assemblyline.common.inventory.container.ContainerRancher;
import assemblyline.common.settings.AssemblyLineConfig;
import assemblyline.common.tile.TileRancher;
import assemblyline.prefab.utils.AssemblyTextUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.types.ScreenComponentCountdown;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;

public class ScreenRancher
extends GenericOutlineAreaScreen<ContainerRancher> {
    public ScreenRancher(ContainerRancher container, Inventory inv, Component title) {
        super(container, inv, title);
        this.addComponent((AbstractScreenComponent)new ScreenComponentCountdown(this::getTooltip, () -> {
            TileRancher rancher = (TileRancher)((ContainerRancher)this.menu).getSafeHost();
            if (rancher != null) {
                return 1.0 - (double)((Integer)rancher.ticksSinceCheck.getValue()).intValue() / (double)((Integer)rancher.currentWaitTime.getValue()).intValue();
            }
            return 0.0;
        }, 10, 50));
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(this::getElectricInformation, -25, 2));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(10, 20, 60, 20).setLabel(() -> {
            TileRancher harvester = (TileRancher)((ContainerRancher)this.menu).getSafeHost();
            if (harvester != null) {
                return HandlerHarvesterLines.containsLines(harvester.getBlockPos()) ? AssemblyTextUtils.gui("hidearea", new Object[0]) : AssemblyTextUtils.gui("renderarea", new Object[0]);
            }
            return Component.empty();
        }).setOnPress(button -> this.toggleRendering()));
    }

    private List<? extends FormattedCharSequence> getElectricInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        TileRancher harvester = (TileRancher)((ContainerRancher)this.menu).getSafeHost();
        if (harvester != null) {
            ComponentElectrodynamic electro = (ComponentElectrodynamic)harvester.getComponent(IComponentType.Electrodynamic);
            list.add(AssemblyTextUtils.gui("machine.usage", ChatFormatter.getChatDisplayShort((double)(AssemblyLineConfig.INSTANCE.RANCHER_USAGE.getAsDouble() * (Double)harvester.powerUsageMultiplier.getValue() * 20.0), (IDisplayUnit)DisplayUnits.WATT)).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.DARK_GRAY).getVisualOrderText());
            list.add(AssemblyTextUtils.gui("machine.voltage", ChatFormatter.getChatDisplayShort((double)electro.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE)).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.DARK_GRAY).getVisualOrderText());
        }
        return list;
    }

    @Override
    public boolean isFlipped() {
        return true;
    }

    protected List<? extends FormattedCharSequence> getTooltip() {
        ArrayList<FormattedCharSequence> tips = new ArrayList<FormattedCharSequence>();
        TileRancher harvester = (TileRancher)((ContainerRancher)this.menu).getSafeHost();
        if (harvester != null) {
            tips.add(AssemblyTextUtils.tooltip("cooldown", (Integer)harvester.currentWaitTime.getValue() - (Integer)harvester.ticksSinceCheck.getValue()).withStyle(ChatFormatting.GRAY).getVisualOrderText());
        }
        return tips;
    }
}

