/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.client.screen.generic;

import assemblyline.client.event.levelstage.HandlerHarvesterLines;
import assemblyline.common.tile.util.TileOutlineArea;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import voltaic.prefab.inventory.container.types.GenericContainerBlockEntity;
import voltaic.prefab.screen.GenericScreen;

public abstract class GenericOutlineAreaScreen<T extends GenericContainerBlockEntity<? extends TileOutlineArea>>
extends GenericScreen<T> {
    public GenericOutlineAreaScreen(T container, Inventory inv, Component title) {
        super(container, inv, title);
    }

    protected void containerTick() {
        super.containerTick();
        TileOutlineArea harvester = (TileOutlineArea)((GenericContainerBlockEntity)this.menu).getSafeHost();
        if (harvester != null && HandlerHarvesterLines.containsLines(harvester.getBlockPos())) {
            HandlerHarvesterLines.removeLines(harvester.getBlockPos());
            this.updateBox(harvester);
        }
    }

    public void toggleRendering() {
        TileOutlineArea harvester = (TileOutlineArea)((GenericContainerBlockEntity)this.menu).getSafeHost();
        if (harvester != null) {
            BlockPos pos = harvester.getBlockPos();
            if (HandlerHarvesterLines.containsLines(pos)) {
                HandlerHarvesterLines.removeLines(pos);
            } else {
                this.updateBox(harvester);
            }
        }
    }

    public void updateBox(TileOutlineArea area) {
        HandlerHarvesterLines.addLines(area.getBlockPos(), area.getAABB((Integer)area.width.getValue(), (Integer)area.length.getValue(), (Integer)area.height.getValue(), this.isFlipped()));
    }

    public abstract boolean isFlipped();
}

