/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.common.event;

import assemblyline.common.tile.TileMobGrinder;
import assemblyline.registers.AssemblyLineAttachmentTypes;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.ItemUtils;

@EventBusSubscriber(modid="assemblyline", bus=EventBusSubscriber.Bus.GAME)
public class EventHandler {
    @SubscribeEvent
    public static void captureDroppedItems(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        BlockPos pos = (BlockPos)entity.getData(AssemblyLineAttachmentTypes.GRINDER_KILLED_MOB);
        if (pos.equals((Object)BlockEntityUtils.OUT_OF_REACH)) {
            return;
        }
        BlockEntity blockEntity = entity.level().getBlockEntity(pos);
        if (blockEntity instanceof TileMobGrinder) {
            TileMobGrinder grinder = (TileMobGrinder)blockEntity;
            ArrayList droppedItems = new ArrayList();
            event.getDrops().forEach(h -> droppedItems.add(h.getItem()));
            if (droppedItems.isEmpty()) {
                return;
            }
            ComponentInventory inv = (ComponentInventory)grinder.getComponent(IComponentType.Inventory);
            int max = inv.getOutputStartIndex() + inv.getOutputContents().size();
            block0: for (ItemStack item : droppedItems) {
                for (int i = inv.getOutputStartIndex(); i < max; ++i) {
                    ItemStack contained = inv.getItem(i);
                    int room = contained.getMaxStackSize() - contained.getCount();
                    int amtAccepted = Math.min(room, item.getCount());
                    if (amtAccepted == 0) continue;
                    if (contained.isEmpty()) {
                        inv.setItem(i, new ItemStack((ItemLike)item.getItem(), amtAccepted));
                        item.shrink(amtAccepted);
                    } else if (ItemUtils.testItems((Item)item.getItem(), (Item[])new Item[]{contained.getItem()})) {
                        contained.grow(amtAccepted);
                        item.shrink(amtAccepted);
                        inv.setChanged();
                    }
                    if (item.isEmpty()) continue block0;
                }
            }
            event.setCanceled(true);
        }
    }
}

