/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.common.tile;

import assemblyline.common.block.subtype.SubtypeAssemblyMachine;
import assemblyline.registers.AssemblyLineBlocks;
import assemblyline.registers.AssemblyLineTiles;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;

public class TileCrate
extends GenericTile {
    public final int size;

    public TileCrate(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)AssemblyLineTiles.TILE_CRATE.get(), worldPosition, blockState);
        int size = 64;
        if (blockState.is((Block)AssemblyLineBlocks.BLOCKS_ASSEMBLYMACHINES.getValue((Object)SubtypeAssemblyMachine.crate))) {
            size = 64;
        } else if (blockState.is((Block)AssemblyLineBlocks.BLOCKS_ASSEMBLYMACHINES.getValue((Object)SubtypeAssemblyMachine.cratemedium))) {
            size = 128;
        } else if (blockState.is((Block)AssemblyLineBlocks.BLOCKS_ASSEMBLYMACHINES.getValue((Object)SubtypeAssemblyMachine.cratelarge))) {
            size = 256;
        }
        this.size = size;
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().forceSize(this.size)).getSlots(this::getSlotsForFace).valid(this::isItemValidForSlot).setSlotsForAllDirections(new Integer[]{0}));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this));
    }

    public HashSet<Integer> getSlotsForFace(Direction side) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i = 0; i < ((ComponentInventory)this.getComponent(IComponentType.Inventory)).getContainerSize(); ++i) {
            set.add(i);
        }
        return set;
    }

    public boolean isItemValidForSlot(int index, ItemStack stack, ComponentInventory inv) {
        if (stack.isEmpty()) {
            return true;
        }
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack s = inv.getItem(i);
            if (s.isEmpty() || stack.getItem() == s.getItem()) continue;
            return false;
        }
        return true;
    }

    public int getCount() {
        int count = 0;
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        count = 0;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            count += stack.getCount();
        }
        return count;
    }

    public int getComparatorSignal() {
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        return (int)((double)this.getCount() / (double)Math.max(1, inv.getContainerSize()) * 15.0);
    }

    public ItemInteractionResult useWithItem(ItemStack used, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.isShiftKeyDown() && !player.getItemInHand(hand).isEmpty()) {
            if (!this.level.isClientSide) {
                player.setItemInHand(hand, HopperBlockEntity.addItem((Container)player.getInventory(), (Container)((Container)this.getComponent(IComponentType.Inventory)), (ItemStack)player.getItemInHand(hand), (Direction)Direction.EAST));
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult useWithoutItem(Player player, BlockHitResult hit) {
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (!this.level.isClientSide()) {
                ItemEntity item = new ItemEntity(this.level, player.getX() + 0.5, player.getY() + 0.5, player.getZ() + 0.5, stack.copy());
                this.level.addFreshEntity((Entity)item);
                inv.removeItem(i, stack.getCount());
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }
}

