/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.common.tile;

import assemblyline.client.event.levelstage.HandlerFarmerLines;
import assemblyline.common.inventory.container.ContainerFarmer;
import assemblyline.common.settings.AssemblyLineConfig;
import assemblyline.registers.AssemblyLineTiles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.SpecialPlantable;
import net.neoforged.neoforge.common.Tags;
import voltaic.common.item.ItemUpgrade;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentForgeEnergy;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.ItemUtils;
import voltaic.prefab.utilities.object.TransferPack;

public class TileFarmer
extends GenericTile {
    public static final int DEFAULT_WAIT_TICKS = 60;
    public static final int FASTEST_WAIT_TICKS = 1;
    public static final int MAX_WIDTH_FARMER = 27;
    public static final int MAX_LENGTH_FARMER = 27;
    public static final int OPERATION_OFFSET = 2;
    public static final int MIN_CHORUS_PLANT_SIZE = 5;
    private static final int[][] TREE_SCANNING_GRID = new int[][]{{1, 1, 1}, {1, 1, 0}, {1, 1, -1}, {1, 0, 1}, {1, 0, 0}, {1, 0, -1}, {0, 1, 1}, {0, 1, 0}, {0, 1, -1}, {0, 0, 1}, {0, 0, 0}, {0, 0, -1}, {-1, 1, 1}, {-1, 1, 0}, {-1, 1, -1}, {-1, 0, 1}, {-1, 0, 0}, {-1, 0, -1}};
    private static final List<TagKey<Item>> VANILLA_SEED_TAGS = List.of(Tags.Items.SEEDS_BEETROOT, Tags.Items.SEEDS_MELON, Tags.Items.SEEDS_WHEAT, Tags.Items.SEEDS_PUMPKIN, Tags.Items.CROPS_CACTUS, Tags.Items.CROPS_SUGAR_CANE, Tags.Items.CROPS_CARROT, Tags.Items.CROPS_COCOA_BEAN, Tags.Items.CROPS_NETHER_WART, Tags.Items.CROPS_POTATO, ItemTags.SAPLINGS);
    private static final List<TagKey<Item>> VANILLA_TILLABLE_SEED_TAGS = List.of(Tags.Items.SEEDS_BEETROOT, Tags.Items.SEEDS_MELON, Tags.Items.SEEDS_WHEAT, Tags.Items.SEEDS_PUMPKIN, Tags.Items.CROPS_CARROT, Tags.Items.CROPS_POTATO);
    private static final List<Item> VANILLA_SEED_ITEMS = List.of(Items.BAMBOO, Items.CHORUS_FLOWER);
    private int prevXShift = 0;
    private int prevZShift = 0;
    private final List<List<Integer>> quadrants = new ArrayList<List<Integer>>();
    public final SingleProperty<Boolean> refillEmpty = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "refillempty", (Object)false));
    public final SingleProperty<Boolean> fullGrowBonemeal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "fullbonemeal", (Object)false));
    public final SingleProperty<Integer> ticksSinceCheck = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "ticks", (Object)0));
    public final SingleProperty<Integer> currentWaitTime = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "waitTime", (Object)60));
    public final SingleProperty<Double> powerUsageMultiplier = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "powermultiplier", (Object)1.0));
    public final SingleProperty<Integer> currentWidth = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "currwidth", (Object)3));
    public final SingleProperty<Integer> currentLength = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "currlength", (Object)3));

    public TileFarmer(BlockPos pos, BlockState state) {
        super((BlockEntityType)AssemblyLineTiles.TILE_FARMER.get(), pos, state);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).voltage(120.0).maxJoules(AssemblyLineConfig.INSTANCE.FARMER_USAGE.getAsDouble() * 20.0));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(10).outputs(9).upgrades(3)).setSlotsByDirection(BlockEntityUtils.MachineDirection.RIGHT, new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18}).setSlotsByDirection(BlockEntityUtils.MachineDirection.LEFT, new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18}).setSlotsByDirection(BlockEntityUtils.MachineDirection.FRONT, new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18}).setSlotsByDirection(BlockEntityUtils.MachineDirection.BACK, new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18}).validUpgrades(ContainerFarmer.VALID_UPGRADES).valid(TileFarmer.machineValidator()));
        this.addComponent((IComponent)new ComponentContainerProvider("farmer", (GenericTile)this).createMenu((id, player) -> new ContainerFarmer((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
        this.addComponent((IComponent)new ComponentForgeEnergy((GenericTile)this));
    }

    public void tickServer(ComponentTickable tick) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < AssemblyLineConfig.INSTANCE.FARMER_USAGE.getAsDouble() * (Double)this.powerUsageMultiplier.getValue()) {
            return;
        }
        electro.joules(electro.getJoulesStored() - AssemblyLineConfig.INSTANCE.FARMER_USAGE.getAsDouble() * (Double)this.powerUsageMultiplier.getValue());
        this.ticksSinceCheck.setValue((Object)((Integer)this.ticksSinceCheck.getValue() + 1));
        if ((Integer)this.ticksSinceCheck.getValue() >= (Integer)this.currentWaitTime.getValue()) {
            this.ticksSinceCheck.setValue((Object)0);
        }
        if ((Integer)this.ticksSinceCheck.getValue() != 0) {
            return;
        }
        BlockPos machinePos = this.getBlockPos();
        BlockPos startPos = new BlockPos(machinePos.getX() - (Integer)this.currentWidth.getValue() / 2, machinePos.getY() + 2, machinePos.getZ() - (Integer)this.currentLength.getValue() / 2);
        this.genQuadrants();
        BlockPos checkPos = new BlockPos(startPos.getX() + this.prevXShift, startPos.getY(), startPos.getZ() + this.prevZShift);
        int quadrant = this.getQuadrant(this.prevXShift, this.prevZShift);
        if (quadrant >= 0) {
            this.handleHarvest(checkPos, quadrant);
            this.handlePlanting(checkPos, quadrant);
        }
        this.refillInputs();
        ++this.prevZShift;
        if (this.prevZShift >= (Integer)this.currentLength.getValue()) {
            this.prevZShift = 0;
            ++this.prevXShift;
            if (this.prevXShift >= (Integer)this.currentWidth.getValue()) {
                this.prevXShift = 0;
            }
        }
        this.quadrants.clear();
    }

    private void handleHarvest(BlockPos checkPos, int quadrant) {
        CropBlock crop;
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        if (!inv.areOutputsEmpty()) {
            return;
        }
        Level world = this.getLevel();
        BlockState checkState = world.getBlockState(checkPos);
        Block checkBlock = checkState.getBlock();
        if (checkBlock instanceof CropBlock && (crop = (CropBlock)checkBlock).isMaxAge(checkState)) {
            TileFarmer.breakBlock(checkState, world, checkPos, inv, SoundEvents.CROP_BREAK);
        } else if (checkState.is(Blocks.PUMPKIN) || checkState.is(Blocks.MELON)) {
            TileFarmer.breakBlock(checkState, world, checkPos, inv, SoundEvents.WOOD_BREAK);
        } else if (checkBlock instanceof CactusBlock || checkBlock instanceof SugarCaneBlock) {
            BlockPos above = checkPos.above();
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            while (world.getBlockState(above).is(checkBlock)) {
                positions.add(above);
                above = above.above();
            }
            for (int i = positions.size() - 1; i >= 0; --i) {
                BlockPos currPos = (BlockPos)positions.get(i);
                BlockState currState = world.getBlockState(currPos);
                if (checkBlock instanceof CactusBlock) {
                    TileFarmer.breakBlock(currState, world, currPos, inv, SoundEvents.WOOL_BREAK);
                    continue;
                }
                TileFarmer.breakBlock(currState, world, currPos, inv, SoundEvents.GRASS_BREAK);
            }
        } else if (checkBlock instanceof NetherWartBlock && (Integer)checkState.getValue((Property)NetherWartBlock.AGE) == 3) {
            TileFarmer.breakBlock(checkState, world, checkPos, inv, SoundEvents.NETHER_WART_BREAK);
        } else if (checkState.is(BlockTags.LOGS)) {
            TileFarmer.handleTree(world, checkPos, inv);
        } else if (checkState.is(Blocks.BAMBOO_SAPLING)) {
            BlockPos above = checkPos.above();
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            while (world.getBlockState(above).getBlock() instanceof BambooStalkBlock) {
                positions.add(above);
                above = above.above();
            }
            for (int i = positions.size() - 1; i >= 0; --i) {
                BlockPos currPos = (BlockPos)positions.get(i);
                BlockState currState = world.getBlockState(currPos);
                TileFarmer.breakBlock(currState, world, currPos, inv, SoundEvents.GRASS_BREAK);
            }
        } else if (checkState.getBlock() instanceof ChorusPlantBlock) {
            TileFarmer.handleChorusTree(world, checkPos, inv);
        }
    }

    private static void handleChorusTree(Level world, BlockPos checkPos, ComponentInventory inv) {
        ArrayList<BlockPos> scannedBlocks = new ArrayList<BlockPos>(64);
        ConcurrentLinkedQueue<BlockPos> toScan = new ConcurrentLinkedQueue<BlockPos>();
        HashSet<BlockPos> chorusBlockSet = new HashSet<BlockPos>(64);
        HashSet<BlockPos> chorusFlowerSet = new HashSet<BlockPos>(64);
        toScan.add(checkPos);
        chorusBlockSet.add(checkPos);
        BlockState currState = world.getBlockState(checkPos);
        Block currBlock = currState.getBlock();
        while (!toScan.isEmpty()) {
            BlockPos itemPos = (BlockPos)toScan.remove();
            for (int[] offset : TREE_SCANNING_GRID) {
                BlockPos currPos = itemPos.offset(offset[0], offset[1], offset[2]);
                if (scannedBlocks.contains(currPos)) continue;
                scannedBlocks.add(itemPos);
                currState = world.getBlockState(currPos);
                currBlock = currState.getBlock();
                if (currBlock instanceof ChorusPlantBlock) {
                    toScan.add(currPos);
                    chorusBlockSet.add(currPos);
                    continue;
                }
                if (!(currBlock instanceof ChorusFlowerBlock)) continue;
                toScan.add(currPos);
                chorusFlowerSet.add(currPos);
            }
        }
        if (chorusFlowerSet.size() + chorusBlockSet.size() <= 5) {
            return;
        }
        ArrayList validBlocks = new ArrayList(chorusBlockSet);
        validBlocks.sort((pos1, pos2) -> pos2.getY() - pos1.getY());
        Object object = chorusFlowerSet.iterator();
        while (object.hasNext()) {
            BlockPos pos = (BlockPos)object.next();
            TileFarmer.breakBlock(world.getBlockState(pos), world, pos, inv, SoundEvents.WOOD_BREAK);
        }
        for (BlockPos pos : validBlocks) {
            TileFarmer.breakBlock(world.getBlockState(pos), world, pos, inv, SoundEvents.WOOD_BREAK);
        }
    }

    private static void handleTree(Level world, BlockPos checkPos, ComponentInventory inv) {
        ArrayList<BlockPos> scannedBlocks = new ArrayList<BlockPos>(64);
        ConcurrentLinkedQueue<BlockPos> toScan = new ConcurrentLinkedQueue<BlockPos>();
        toScan.add(checkPos);
        BlockState currState = world.getBlockState(checkPos);
        TileFarmer.breakBlock(currState, world, checkPos, inv, currState.is(BlockTags.LEAVES) ? SoundEvents.GRASS_BREAK : SoundEvents.WOOD_BREAK);
        while (!toScan.isEmpty()) {
            BlockPos itemPos = (BlockPos)toScan.remove();
            for (int[] offset : TREE_SCANNING_GRID) {
                BlockPos currPos = itemPos.offset(offset[0], offset[1], offset[2]);
                if (scannedBlocks.contains(currPos)) continue;
                scannedBlocks.add(itemPos);
                currState = world.getBlockState(currPos);
                boolean isLeaves = currState.is(BlockTags.LEAVES);
                if (!currState.is(BlockTags.LOGS) && !isLeaves) continue;
                toScan.add(currPos);
                TileFarmer.breakBlock(currState, world, currPos, inv, isLeaves ? SoundEvents.GRASS_BREAK : SoundEvents.WOOD_BREAK);
            }
        }
    }

    private static void breakBlock(BlockState checkState, Level world, BlockPos checkPos, ComponentInventory inv, SoundEvent event) {
        List drops = Block.getDrops((BlockState)checkState, (ServerLevel)((ServerLevel)world), (BlockPos)checkPos, null);
        if (checkState.is(Blocks.CHORUS_FLOWER)) {
            drops.add(new ItemStack((ItemLike)Blocks.CHORUS_FLOWER));
        }
        int max = inv.getOutputStartIndex() + inv.getOutputContents().size();
        block0: for (ItemStack item : drops) {
            for (int i = inv.getOutputStartIndex(); i < max; ++i) {
                ItemStack contained = inv.getItem(i);
                int room = contained.getMaxStackSize() - contained.getCount();
                int amtAccepted = Math.min(room, item.getCount());
                if (amtAccepted == 0) continue;
                if (contained.isEmpty()) {
                    inv.setItem(i, new ItemStack((ItemLike)item.getItem(), amtAccepted));
                    item.shrink(amtAccepted);
                } else if (ItemUtils.testItems((Item)item.getItem(), (Item[])new Item[]{contained.getItem()})) {
                    contained.grow(amtAccepted);
                    item.shrink(amtAccepted);
                    inv.setChanged();
                }
                if (item.isEmpty()) continue block0;
            }
        }
        world.destroyBlock(checkPos, false);
        world.playSound(null, checkPos, event, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void handlePlanting(BlockPos checkPos, int quadrant) {
        Item item;
        Level world = this.getLevel();
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        List inputs = inv.getInputContents();
        ItemStack plantingContents = (ItemStack)inputs.get(quadrant);
        ItemStack bonemeal = (ItemStack)inputs.get(9);
        BlockState checkState = world.getBlockState(checkPos);
        BlockPos below = checkPos.below();
        BlockState belowState = world.getBlockState(below);
        BlockState farmland = Blocks.FARMLAND.defaultBlockState();
        boolean isAir = checkState.isAir();
        if (isAir && (item = plantingContents.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            if (blockItem instanceof SpecialPlantable) {
                SpecialPlantable plantable = (SpecialPlantable)blockItem;
                if (plantable.canPlacePlantAtPosition(plantingContents, (LevelReader)this.level, checkPos, Direction.DOWN)) {
                    plantable.spawnPlantAtPosition(plantingContents, (LevelAccessor)this.level, checkPos, Direction.DOWN);
                    world.playSound(null, checkPos, SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 1.0f, 1.0f);
                    plantingContents.shrink(1);
                    electro.extractPower(TransferPack.joulesVoltage((double)(AssemblyLineConfig.INSTANCE.FARMER_USAGE.getAsDouble() * (Double)this.powerUsageMultiplier.getValue()), (double)electro.getVoltage()), false);
                } else if (belowState.is(BlockTags.DIRT)) {
                    world.setBlockAndUpdate(below, farmland);
                    world.playSound(null, below, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                    electro.extractPower(TransferPack.joulesVoltage((double)(AssemblyLineConfig.INSTANCE.FARMER_USAGE.getAsDouble() * (Double)this.powerUsageMultiplier.getValue()), (double)electro.getVoltage()), false);
                }
            } else if (TileFarmer.checkVanilla(plantingContents, blockItem)) {
                if (block.defaultBlockState().canSurvive((LevelReader)world, checkPos)) {
                    world.setBlockAndUpdate(checkPos, block.defaultBlockState());
                    world.playSound(null, checkPos, SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 1.0f, 1.0f);
                    plantingContents.shrink(1);
                    electro.extractPower(TransferPack.joulesVoltage((double)(AssemblyLineConfig.INSTANCE.FARMER_USAGE.getAsDouble() * (Double)this.powerUsageMultiplier.getValue()), (double)electro.getVoltage()), false);
                } else if (belowState.is(BlockTags.DIRT) && TileFarmer.isVanillaTillable(plantingContents)) {
                    world.setBlockAndUpdate(below, farmland);
                    world.playSound(null, below, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                    world.setBlockAndUpdate(checkPos, block.defaultBlockState());
                    world.playSound(null, checkPos, SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 1.0f, 1.0f);
                    plantingContents.shrink(1);
                    electro.extractPower(TransferPack.joulesVoltage((double)(AssemblyLineConfig.INSTANCE.FARMER_USAGE.getAsDouble() * (Double)this.powerUsageMultiplier.getValue()), (double)electro.getVoltage()), false);
                }
            }
        }
        checkState = world.getBlockState(checkPos);
        if (bonemeal.getItem() instanceof BoneMealItem && bonemeal.getCount() > 0) {
            if (((Boolean)this.fullGrowBonemeal.getValue()).booleanValue()) {
                BonemealableBlock bone;
                Block block;
                while (bonemeal.getCount() > 0 && (block = checkState.getBlock()) instanceof BonemealableBlock && (bone = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)world, checkPos, checkState)) {
                    bone.performBonemeal((ServerLevel)world, world.getRandom(), checkPos, checkState);
                    bonemeal.shrink(1);
                    checkState = world.getBlockState(checkPos);
                }
            } else {
                BonemealableBlock bone;
                item = checkState.getBlock();
                if (item instanceof BonemealableBlock && (bone = (BonemealableBlock)item).isValidBonemealTarget((LevelReader)world, checkPos, checkState)) {
                    bone.performBonemeal((ServerLevel)world, world.getRandom(), checkPos, checkState);
                    bonemeal.shrink(1);
                }
            }
        }
    }

    private static boolean checkVanilla(ItemStack plantingContents, BlockItem blockItem) {
        for (TagKey<Item> tag : VANILLA_SEED_TAGS) {
            if (!plantingContents.is(tag)) continue;
            return true;
        }
        for (Item item : VANILLA_SEED_ITEMS) {
            if (!plantingContents.is(item)) continue;
            return true;
        }
        return false;
    }

    private static boolean isVanillaTillable(ItemStack plantingContents) {
        for (TagKey<Item> tag : VANILLA_TILLABLE_SEED_TAGS) {
            if (!plantingContents.is(tag)) continue;
            return true;
        }
        return false;
    }

    private void refillInputs() {
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        List inputs = inv.getInputContents();
        for (int i = 0; i < inputs.size(); ++i) {
            ItemStack input = (ItemStack)inputs.get(i);
            for (ItemStack output : inv.getOutputContents()) {
                BlockItem blockItem;
                Item room2;
                if (output.isEmpty()) continue;
                if (ItemUtils.testItems((Item)input.getItem(), (Item[])new Item[]{output.getItem()})) {
                    int room2 = input.getMaxStackSize() - input.getCount();
                    int accepted = room2 > output.getCount() ? output.getCount() : room2;
                    input.grow(accepted);
                    output.shrink(accepted);
                    continue;
                }
                if (!((Boolean)this.refillEmpty.getValue()).booleanValue() || !input.isEmpty() || !((room2 = output.getItem()) instanceof BlockItem) || !((blockItem = (BlockItem)room2).getBlock() instanceof SpecialPlantable)) continue;
                int room3 = inv.getMaxStackSize();
                int amountAccepted = room3 > output.getCount() ? output.getCount() : room3;
                inv.setItem(i, new ItemStack((ItemLike)output.getItem(), amountAccepted).copy());
                output.shrink(amountAccepted);
            }
        }
    }

    public List<AABB> getLines(TileFarmer farmer) {
        BlockPos machinePos = farmer.getBlockPos();
        int multiplier = (Integer)farmer.currentWidth.getValue() / 3;
        int x = machinePos.getX();
        int y = machinePos.getY() + 2;
        int z = machinePos.getZ();
        ArrayList<AABB> boundingBoxes = new ArrayList<AABB>();
        int xOffset = (Integer)farmer.currentWidth.getValue() / 2;
        int zOffset = (Integer)farmer.currentLength.getValue() / 2;
        if (multiplier == 1) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    boundingBoxes.add(new AABB((double)(x + i), (double)y, (double)(z + j), (double)(x + i + 1), (double)(y + 1), (double)(z + j + 1)));
                }
            }
        } else {
            for (int i = 0; i <= 2; ++i) {
                for (int j = 0; j <= 2; ++j) {
                    BlockPos startPos = new BlockPos(x + i * multiplier - xOffset, y, z + j * multiplier - zOffset);
                    BlockPos endPos = new BlockPos(x + (i + 1) * multiplier - xOffset - 1, y, z + (j + 1) * multiplier - 1 - zOffset);
                    boundingBoxes.add(AABB.encapsulatingFullBlocks((BlockPos)startPos, (BlockPos)endPos));
                }
            }
        }
        return boundingBoxes;
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("xPos", this.prevXShift);
        compound.putInt("zPos", this.prevZShift);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.prevXShift = compound.getInt("xPos");
        this.prevZShift = compound.getInt("zPos");
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.getLevel().isClientSide) {
            HandlerFarmerLines.remove(this.getBlockPos());
        }
    }

    private int getQuadrant(int xShift, int zShift) {
        for (int i = 0; i < this.quadrants.size(); ++i) {
            List<Integer> quadrant = this.quadrants.get(i);
            if (!TileFarmer.matchesQuadrant(quadrant, xShift, zShift)) continue;
            return i;
        }
        return -1;
    }

    private void genQuadrants() {
        this.quadrants.clear();
        int multiplier = (Integer)this.currentLength.getValue() / 3;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ArrayList<Integer> quadrant = new ArrayList<Integer>();
                if (multiplier == 1) {
                    quadrant.add(i);
                    quadrant.add(i);
                    quadrant.add(j);
                    quadrant.add(j);
                } else {
                    quadrant.add(i * multiplier);
                    quadrant.add((i + 1) * multiplier - 1);
                    quadrant.add(j * multiplier);
                    quadrant.add((j + 1) * multiplier - 1);
                }
                this.quadrants.add(quadrant);
            }
        }
    }

    private static boolean matchesQuadrant(List<Integer> quadrant, int xShift, int zShift) {
        if (quadrant.get(0) <= xShift && quadrant.get(1) >= xShift) {
            return quadrant.get(2) <= zShift && quadrant.get(3) >= zShift;
        }
        return false;
    }

    public void onInventoryChange(ComponentInventory inv, int slot) {
        super.onInventoryChange(inv, slot);
        if (slot == -1 || slot >= inv.getUpgradeSlotStartIndex()) {
            int waitTime = 60;
            int width = 3;
            int length = 3;
            double powerMultiplier = 1.0;
            block6: for (ItemStack stack : inv.getUpgradeContents()) {
                if (stack.isEmpty()) continue;
                ItemUpgrade upgrade = (ItemUpgrade)stack.getItem();
                switch (upgrade.subtype) {
                    case advancedspeed: {
                        int i;
                        for (i = 0; i < stack.getCount(); ++i) {
                            waitTime = Math.max(waitTime / 4, 1);
                            powerMultiplier *= 1.5;
                        }
                        continue block6;
                    }
                    case basicspeed: {
                        int i;
                        for (i = 0; i < stack.getCount(); ++i) {
                            waitTime = (int)Math.max((double)waitTime / 1.5, 1.0);
                            powerMultiplier *= 1.5;
                        }
                        continue block6;
                    }
                    case range: {
                        int i;
                        for (i = 0; i < stack.getCount(); ++i) {
                            length = Math.min(length + 6, 27);
                            width = Math.min(width + 6, 27);
                            powerMultiplier *= 1.3;
                        }
                        continue block6;
                    }
                    case itemoutput: {
                        upgrade.subtype.applyUpgrade.accept((Object)this, (Object)stack, (Object)0);
                        break;
                    }
                }
            }
            this.currentWaitTime.setValue((Object)waitTime);
            this.currentWidth.setValue((Object)width);
            this.currentLength.setValue((Object)length);
            this.powerUsageMultiplier.setValue((Object)powerMultiplier);
        }
    }
}

