/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.common.tile.belt;

import assemblyline.common.inventory.container.ContainerSorterBelt;
import assemblyline.common.tile.belt.utils.ConveyorBeltProperties;
import assemblyline.common.tile.belt.utils.ConveyorClass;
import assemblyline.common.tile.belt.utils.ConveyorType;
import assemblyline.common.tile.belt.utils.GenericTileConveyorBelt;
import assemblyline.registers.AssemblyLineTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentInventory;

public class TileSorterBelt
extends GenericTileConveyorBelt {
    public TileSorterBelt(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)AssemblyLineTiles.TILE_SORTERBELT.get(), worldPosition, blockState, ConveyorBeltProperties.builder(ConveyorClass.REGULAR).setNoPuller().setInvSize(19));
        this.addComponent((IComponent)new ComponentContainerProvider("sorterbelt", (GenericTile)this).createMenu((id, player) -> new ContainerSorterBelt((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    @Override
    public Direction getDirectionForNext() {
        boolean zIs;
        boolean xIs;
        Direction superDirection = super.getDirectionForNext();
        float stepX = superDirection.getStepX();
        float stepZ = superDirection.getStepZ();
        Vector3f localVector = this.getLocalItemLocationVector();
        float absX = Math.abs(localVector.x());
        float absZ = Math.abs(localVector.z());
        boolean bl = stepX != 0.0f && stepX < 0.0f ? absX <= 0.5f : (xIs = absX >= 0.5f);
        boolean bl2 = stepZ != 0.0f && stepZ < 0.0f ? absZ <= 0.5f : (zIs = absZ >= 0.5f);
        if (xIs || zIs) {
            ItemStack comparator;
            int i;
            ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
            ItemStack onBelt = this.getItemOnBelt();
            boolean isLeft = false;
            boolean isRight = false;
            for (i = 1; i < 10; ++i) {
                comparator = inv.getItem(i);
                if (!ItemStack.isSameItemSameComponents((ItemStack)comparator, (ItemStack)onBelt)) continue;
                isLeft = true;
                break;
            }
            for (i = 10; i < 19; ++i) {
                comparator = inv.getItem(i);
                if (!ItemStack.isSameItemSameComponents((ItemStack)comparator, (ItemStack)onBelt)) continue;
                isRight = true;
                break;
            }
            if (isLeft) {
                return superDirection.getCounterClockWise();
            }
            if (isRight) {
                return superDirection.getClockWise();
            }
            return superDirection;
        }
        return superDirection;
    }

    @Override
    public ConveyorType getConveyorType() {
        return ConveyorType.HORIZONTAL;
    }

    @Override
    public void cycleConveyorType() {
    }
}

