/*
 * Decompiled with CFR 0.152.
 */
package assemblyline.common.tile.belt.utils;

import assemblyline.common.settings.AssemblyLineConfig;
import assemblyline.common.tile.belt.utils.ConveyorBeltProperties;
import assemblyline.common.tile.belt.utils.ConveyorType;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.joml.Vector3f;
import voltaic.common.tags.VoltaicTags;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentForgeEnergy;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.Location;

public abstract class GenericTileConveyorBelt
extends GenericTile {
    public static final int MIN_SPREAD = 0;
    public static final BlockPos[] SPREAD_OFFSETS = new BlockPos[]{new BlockPos(0, 1, 0), new BlockPos(0, -1, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, -1, 1), new BlockPos(0, -1, -1), new BlockPos(1, -1, 0), new BlockPos(-1, -1, 0), new BlockPos(0, 1, 1), new BlockPos(0, 1, -1), new BlockPos(1, 1, 0), new BlockPos(-1, 1, 0)};
    public final SingleProperty<Integer> currentSpread = (SingleProperty)((SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "currentspread", (Object)0))).setNoUpdateServer();
    public final SingleProperty<Boolean> running = (SingleProperty)((SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "running", (Object)false))).setNoUpdateServer();
    public final SingleProperty<Location> itemLocation = (SingleProperty)((SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.LOCATION, "conveyorobject", (Object)new Location(0.0, 0.0, 0.0)))).setNoUpdateServer();
    public final SingleProperty<Integer> conveyorType = (SingleProperty)((SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "conveyortype", (Object)ConveyorType.HORIZONTAL.ordinal()))).setNoUpdateServer();
    public final SingleProperty<Boolean> isPusher = (SingleProperty)((SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "pusher", (Object)false))).setNoUpdateServer();
    public final SingleProperty<Boolean> isPuller = (SingleProperty)((SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "puller", (Object)false))).setNoUpdateServer();
    public int wait = 0;
    private CachedTileOutput nextCache;
    private CachedTileOutput beforeCache;
    private boolean hasDroppedThisTick = false;
    private final ConveyorBeltProperties properties;

    public GenericTileConveyorBelt(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState, ConveyorBeltProperties properties) {
        super(type, worldPosition, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickCommon(this::tickCommon));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().forceSize(properties.invSize)));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT}).maxJoules(AssemblyLineConfig.INSTANCE.CONVEYORBELT_USAGE.getAsDouble() * 100.0));
        this.addComponent((IComponent)new ComponentForgeEnergy((GenericTile)this));
        this.properties = properties;
    }

    public void tickCommon(ComponentTickable tickable) {
        this.hasDroppedThisTick = false;
        if (this.nextCache == null) {
            this.nextCache = new CachedTileOutput(this.getLevel(), this.getNextPos());
        }
        if (this.beforeCache == null) {
            this.beforeCache = new CachedTileOutput(this.getLevel(), this.getBeforePos());
        }
        if (tickable.getTicks() % 5L == 0L) {
            this.nextCache.update(this.getNextPos());
            this.beforeCache.update(this.getBeforePos());
        }
        if (!this.level.isClientSide) {
            this.isPusher.setValue((Object)(this.properties.canBePusher && this.nextCache.valid() && !(this.nextCache.getSafe() instanceof GenericTileConveyorBelt) && this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.nextCache.getPos(), ((BlockEntity)this.nextCache.getSafe()).getBlockState(), (BlockEntity)this.nextCache.getSafe(), (Object)this.getDirectionForNext().getOpposite()) != null ? 1 : 0));
            this.isPuller.setValue((Object)(this.properties.canBePuller && this.beforeCache.valid() && !(this.beforeCache.getSafe() instanceof GenericTileConveyorBelt) && this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.beforeCache.getPos(), ((BlockEntity)this.beforeCache.getSafe()).getBlockState(), (BlockEntity)this.beforeCache.getSafe(), (Object)this.getDirectionForLast().getOpposite()) != null ? 1 : 0));
            int currSpread = (Integer)this.currentSpread.getValue();
            int maxSpread = 0;
            for (BlockPos offset : SPREAD_OFFSETS) {
                BlockEntity offsetTile = this.level.getBlockEntity(this.worldPosition.offset((Vec3i)offset));
                if (!(offsetTile instanceof GenericTileConveyorBelt)) continue;
                GenericTileConveyorBelt belt = (GenericTileConveyorBelt)offsetTile;
                int offsetSpread = (Integer)belt.currentSpread.getValue();
                if (offsetSpread - 1 <= maxSpread) continue;
                maxSpread = offsetSpread - 1;
            }
            ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
            this.currentSpread.setValue((Object)maxSpread);
            if (currSpread > (Integer)this.currentSpread.getValue()) {
                this.currentSpread.setValue((Object)0);
            }
            if ((Integer)this.currentSpread.getValue() == 0 || ((Integer)this.currentSpread.getValue()).intValue() == AssemblyLineConfig.INSTANCE.CONVEYOR_MAX_SPREAD.getAsInt()) {
                if (electro.getJoulesStored() < AssemblyLineConfig.INSTANCE.CONVEYORBELT_USAGE.getAsDouble()) {
                    this.currentSpread.setValue((Object)0);
                } else {
                    electro.joules(electro.getJoulesStored() - AssemblyLineConfig.INSTANCE.CONVEYORBELT_USAGE.getAsDouble());
                    this.currentSpread.setValue((Object)AssemblyLineConfig.INSTANCE.CONVEYOR_MAX_SPREAD.getAsInt());
                }
            }
            this.running.setValue((Object)((Integer)this.currentSpread.getValue() > 0 ? 1 : 0));
        }
        if (this.getItemOnBelt().isEmpty()) {
            this.itemLocation.setValue((Object)this.getDefaultItemLocation(false));
            if (!this.level.isClientSide && ((Boolean)this.running.getValue()).booleanValue()) {
                this.pullItemFromInventory();
            }
            if (this.getItemOnBelt().isEmpty()) {
                return;
            }
        }
        if (!((Boolean)this.running.getValue()).booleanValue()) {
            return;
        }
        Vector3f move = this.getDirectionVector();
        if (this.canMove()) {
            move.mul(0.0625f);
            double speed = this.properties.conveyorClass.speed;
            ConveyorType type = this.getConveyorType();
            double x = (double)move.x() * speed * (double)(type != ConveyorType.VERTICAL ? 1 : 0);
            double y = move.y();
            double z = (double)move.z() * speed * (double)(type != ConveyorType.VERTICAL ? 1 : 0);
            if (type != ConveyorType.HORIZONTAL) {
                y += (double)(0.0625f * (float)(type == ConveyorType.SLOPED_DOWN ? -1 : 1)) * speed;
            }
            if (type == ConveyorType.VERTICAL) {
                this.itemLocation.setValue((Object)this.getDefaultItemLocation(false).add(0.0, ((Location)this.itemLocation.getValue()).y() - this.getDefaultItemLocation(false).y(), 0.0));
            }
            this.itemLocation.setValue((Object)((Location)this.itemLocation.getValue()).add(x, y, z));
            return;
        }
        if (!this.nextCache.valid()) {
            this.dropItem(this.getItemOnBelt(), move);
            return;
        }
        BlockEntity nextBlockEntity = (BlockEntity)this.nextCache.getSafe();
        if (nextBlockEntity instanceof GenericTileConveyorBelt) {
            GenericTileConveyorBelt belt = (GenericTileConveyorBelt)nextBlockEntity;
            if (belt.getItemOnBelt().isEmpty()) {
                belt.addItemOnBelt(this.getItemOnBelt().copy(), (Location)this.itemLocation.getValue());
                this.setItemOnBelt(ItemStack.EMPTY);
            }
        } else {
            Direction direction = this.getFacing();
            IItemHandler handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, nextBlockEntity.getBlockPos(), nextBlockEntity.getBlockState(), nextBlockEntity, (Object)direction);
            ItemStack stackOnBelt = this.getItemOnBelt().copy();
            if (handler != null && !this.level.isClientSide) {
                if (this.wait == 0) {
                    int amtTaken = 0;
                    for (int targetIndex = 0; targetIndex < handler.getSlots(); ++targetIndex) {
                        ItemStack remainder = handler.insertItem(targetIndex, stackOnBelt, this.level.isClientSide);
                        int taken = stackOnBelt.getCount() - remainder.getCount();
                        if (taken <= 0) continue;
                        amtTaken += taken;
                        stackOnBelt = stackOnBelt.copy();
                        stackOnBelt.shrink(taken);
                        if (stackOnBelt.isEmpty()) break;
                    }
                    stackOnBelt.shrink(amtTaken);
                    this.setItemOnBelt(stackOnBelt);
                    if (amtTaken == 0) {
                        this.wait = 20;
                    }
                } else {
                    --this.wait;
                }
            }
        }
    }

    public void pullItemFromInventory() {
        if (!((Boolean)this.isPuller.getValue()).booleanValue() || !this.getItemOnBelt().isEmpty()) {
            return;
        }
        BlockEntity lastBlockEntity = (BlockEntity)this.beforeCache.getSafe();
        IItemHandler handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, lastBlockEntity.getBlockPos(), lastBlockEntity.getBlockState(), lastBlockEntity, (Object)this.getDirectionForLast().getOpposite());
        if (handler != null) {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack accepted = this.addItemOnBelt(handler.extractItem(slot, 64, true), this.getDefaultItemLocation(true));
                if (accepted.isEmpty()) continue;
                handler.extractItem(slot, accepted.getCount(), this.level.isClientSide);
                break;
            }
        }
    }

    public boolean canMove() {
        if (this.getConveyorType() == ConveyorType.VERTICAL) {
            return this.getLocalItemLocationVector().y < 1.0f;
        }
        Direction next = this.getDirectionForNext();
        BlockPos nextPos = this.getNextPos();
        boolean nextGoesUp = false;
        BlockEntity blockEntity = this.level.getBlockEntity(nextPos);
        if (blockEntity instanceof GenericTileConveyorBelt) {
            GenericTileConveyorBelt belt = (GenericTileConveyorBelt)blockEntity;
            boolean bl = nextGoesUp = belt.getConveyorType() == ConveyorType.SLOPED_UP || belt.getConveyorType() == ConveyorType.SLOPED_DOWN;
            if (!(this.getConveyorType() != ConveyorType.SLOPED_UP && this.getConveyorType() != ConveyorType.SLOPED_DOWN || nextGoesUp)) {
                nextGoesUp = true;
            }
        }
        if (next == Direction.SOUTH) {
            return (double)nextPos.getZ() - ((Location)this.itemLocation.getValue()).z() > (nextGoesUp ? -0.125 : -0.25);
        }
        if (next == Direction.WEST) {
            return (double)nextPos.getX() - ((Location)this.itemLocation.getValue()).x() < (nextGoesUp ? -0.875 : -0.75);
        }
        if (next == Direction.NORTH) {
            return (double)nextPos.getZ() - ((Location)this.itemLocation.getValue()).z() < (nextGoesUp ? -0.875 : -0.75);
        }
        if (next == Direction.EAST) {
            return (double)nextPos.getX() - ((Location)this.itemLocation.getValue()).x() > (nextGoesUp ? -0.125 : -0.25);
        }
        return false;
    }

    public ItemStack addItemOnBelt(ItemStack add, Location object) {
        int room;
        int accepted;
        ItemStack taken = ItemStack.EMPTY;
        if (add.isEmpty()) {
            return taken;
        }
        taken = ItemStack.EMPTY;
        boolean inserted = false;
        boolean newItem = true;
        ItemStack beltItem = this.getItemOnBelt();
        if (beltItem.isEmpty()) {
            taken = add.copy();
            this.setItemOnBelt(add.copy());
            inserted = true;
        } else if (ItemStack.isSameItem((ItemStack)beltItem, (ItemStack)add) && (accepted = Math.min(room = beltItem.getMaxStackSize() - beltItem.getCount(), add.getCount())) > 0) {
            taken = add.copy();
            beltItem.grow(accepted);
            this.setItemOnBelt(beltItem.copy());
            taken.setCount(accepted);
            inserted = true;
            newItem = false;
        }
        if (inserted && newItem) {
            this.itemLocation.setValue((Object)object);
        }
        return taken;
    }

    public void dropItem(ItemStack stackOnBelt, Vector3f move) {
        if (this.hasDroppedThisTick) {
            return;
        }
        this.hasDroppedThisTick = true;
        if (!this.level.isClientSide) {
            Location itemLoc = (Location)this.itemLocation.getValue();
            ItemEntity entity = new ItemEntity(this.level, itemLoc.x(), itemLoc.y(), itemLoc.z(), stackOnBelt.copy());
            entity.setDeltaMovement((double)move.x() / 12.0, 0.09375, (double)move.z() / 12.0);
            entity.setPickUpDelay(20);
            this.level.addFreshEntity((Entity)entity);
        }
        this.setItemOnBelt(ItemStack.EMPTY);
    }

    public BlockPos getNextPos() {
        Direction direction = this.getDirectionForNext();
        return switch (ConveyorType.values()[(Integer)this.conveyorType.getValue()]) {
            case ConveyorType.SLOPED_DOWN -> this.worldPosition.relative(direction).below();
            case ConveyorType.SLOPED_UP -> this.worldPosition.relative(direction).above();
            case ConveyorType.VERTICAL -> {
                GenericTileConveyorBelt belt;
                BlockEntity var3_2 = this.level.getBlockEntity(this.worldPosition.relative(Direction.UP));
                if (var3_2 instanceof GenericTileConveyorBelt && (belt = (GenericTileConveyorBelt)var3_2).getConveyorType() == ConveyorType.VERTICAL) {
                    yield this.worldPosition.relative(Direction.UP);
                }
                yield this.worldPosition.relative(direction).above();
            }
            default -> this.worldPosition.relative(direction);
        };
    }

    public BlockPos getBeforePos() {
        Direction direction = this.getDirectionForLast();
        return switch (ConveyorType.values()[(Integer)this.conveyorType.getValue()]) {
            case ConveyorType.SLOPED_DOWN -> this.worldPosition.relative(direction).above();
            case ConveyorType.SLOPED_UP -> this.worldPosition.relative(direction).below();
            case ConveyorType.VERTICAL -> {
                GenericTileConveyorBelt belt;
                BlockEntity var3_2 = this.level.getBlockEntity(this.worldPosition.relative(Direction.DOWN));
                if (var3_2 instanceof GenericTileConveyorBelt && (belt = (GenericTileConveyorBelt)var3_2).getConveyorType() == ConveyorType.VERTICAL) {
                    yield this.worldPosition.relative(Direction.DOWN);
                }
                yield this.worldPosition.relative(direction).below();
            }
            default -> this.worldPosition.relative(direction);
        };
    }

    public Direction getDirectionForNext() {
        return this.getFacing().getOpposite();
    }

    public Direction getDirectionForLast() {
        return this.getFacing();
    }

    public ItemStack getItemOnBelt() {
        return ((ComponentInventory)this.getComponent(IComponentType.Inventory)).getItem(0);
    }

    public void setItemOnBelt(ItemStack item) {
        ((ComponentInventory)this.getComponent(IComponentType.Inventory)).setItem(0, item);
    }

    public ConveyorType getConveyorType() {
        return ConveyorType.values()[(Integer)this.conveyorType.getValue()];
    }

    public Vector3f getLocalItemLocationVector() {
        return new Vector3f((float)(((Location)this.itemLocation.getValue()).x() - (double)this.worldPosition.getX()), (float)(((Location)this.itemLocation.getValue()).y() - (double)this.worldPosition.getY()), (float)(((Location)this.itemLocation.getValue()).z() - (double)this.worldPosition.getZ()));
    }

    public Vector3f getDirectionVector() {
        Direction direction = this.getDirectionForNext();
        return new Vector3f((float)direction.getStepX(), (float)direction.getStepY(), (float)direction.getStepZ());
    }

    public Location getDefaultItemLocation(boolean setToEnd) {
        double x = (double)this.worldPosition.getX() + 0.5;
        double y = this.worldPosition.getY();
        double z = (double)this.worldPosition.getZ() + 0.5;
        switch (this.getConveyorType()) {
            case SLOPED_DOWN: {
                y += -0.25;
                break;
            }
            case SLOPED_UP: {
                y += 0.5;
            }
        }
        if (setToEnd) {
            Direction directionForNext = this.getDirectionForNext();
            x -= (double)directionForNext.getStepX() / 2.0;
            z -= (double)directionForNext.getStepZ() / 2.0;
        }
        return new Location(x, y, z);
    }

    public void cycleConveyorType() {
        if ((Integer)this.conveyorType.getValue() + 1 <= ConveyorType.values().length - 1) {
            this.conveyorType.setValue((Object)ConveyorType.values()[(Integer)this.conveyorType.getValue() + 1].ordinal());
        } else {
            this.conveyorType.setValue((Object)ConveyorType.values()[0].ordinal());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onEntityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            if (!this.isRemoved()) {
                if (entity.tickCount <= 10) return;
                if (level.isClientSide) return;
                ItemStack stack = item.getItem().copy();
                Location setloc = new Location(entity.position());
                Location defaultLocation = this.getDefaultItemLocation(false);
                setloc.set(setloc.x(), defaultLocation.y(), setloc.z());
                ItemStack inserted = this.addItemOnBelt(stack, setloc).copy();
                stack.shrink(inserted.getCount());
                item.setItem(stack);
                return;
            }
        }
        if ((Boolean)this.running.getValue() == false) return;
        if (!(entity instanceof LivingEntity)) return;
        LivingEntity living = (LivingEntity)entity;
        if (!living.getOnPos().equals((Object)this.getBlockPos())) return;
        if (living instanceof Player && !level.isClientSide()) {
            return;
        }
        if (!(living instanceof Player) && level.isClientSide) {
            return;
        }
        double deltaY = living.getY() - (double)living.getOnPos().getY();
        if (deltaY > 0.3125) {
            return;
        }
        ArrayList armorPieces = new ArrayList();
        living.getArmorSlots().forEach(piece -> armorPieces.add(piece));
        if (armorPieces.size() > 3 && ((ItemStack)armorPieces.get(0)).is(VoltaicTags.Items.INSULATES_PLAYER_FEET)) {
            return;
        }
        Vector3f dirVec = this.getDirectionVector();
        dirVec = dirVec.mul(0.0625f);
        dirVec = dirVec.mul((float)this.properties.conveyorClass.speed);
        living.push(new Vec3((double)dirVec.x, 0.0, (double)dirVec.z));
    }

    public void onBlockDestroyed() {
        if (!this.level.isClientSide) {
            ItemStack stack = this.getItemOnBelt().copy();
            if (stack.isEmpty()) {
                return;
            }
            double d0 = EntityType.ITEM.getWidth();
            double d1 = 1.0 - d0;
            double d2 = d0 / 2.0;
            double d3 = Math.floor(this.getBlockPos().getX()) + this.level.random.nextDouble() * d1 + d2;
            double d4 = Math.floor(this.getBlockPos().getY()) + this.level.random.nextDouble() * d1;
            double d5 = Math.floor(this.getBlockPos().getZ()) + this.level.random.nextDouble() * d1 + d2;
            ItemEntity itementity = new ItemEntity(this.level, d3, d4, d5, stack);
            itementity.setDeltaMovement(this.level.random.triangle(0.0, 0.11485000171139836), this.level.random.triangle(0.2, 0.11485000171139836), this.level.random.triangle(0.0, 0.11485000171139836));
            this.level.addFreshEntity((Entity)itementity);
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("conveyorwait", this.wait);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.wait = compound.getInt("conveyorwait");
    }
}

