/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.tumitranslator.core;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.github._4drian3d.tumitranslator.core.TumiTranslator;
import io.github._4drian3d.tumitranslator.core.annotations.PluginFolder;
import io.github._4drian3d.tumitranslator.core.configuration.Configuration;
import io.github._4drian3d.tumitranslator.core.configuration.ConfigurationContainer;
import io.github._4drian3d.tumitranslator.core.configuration.Messages;
import io.github._4drian3d.tumitranslator.core.locale.ClosestLocaleMatcher;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.slf4j.Logger;

@Singleton
public final class TranslationCore {
    private static final Map<String, String> SYSTEM_PROPERTIES = Map.of("create", "true");
    private static final String translationsFolderName = "translations";
    @Inject
    @PluginFolder
    private Path dataDirectory;
    @Inject
    private Logger logger;
    @Inject
    private ConfigurationContainer<Configuration> configurationContainer;
    @Inject
    private ConfigurationContainer<Messages> messagesContainer;
    @Inject
    private ClosestLocaleMatcher localeMatcher;
    private TumiTranslator tumiTranslator;

    public TumiTranslator translator() {
        return this.tumiTranslator;
    }

    public ConfigurationContainer<Configuration> configurationContainer() {
        return this.configurationContainer;
    }

    public ConfigurationContainer<Messages> messagesContainer() {
        return this.messagesContainer;
    }

    public void loadTranslations() {
        Path translationsPath;
        try {
            translationsPath = this.dataDirectory.resolve(translationsFolderName);
            if (Files.notExists(translationsPath, new LinkOption[0])) {
                Files.createDirectories(translationsPath, new FileAttribute[0]);
                this.processDefaultTranslations(translationsPath);
            }
        }
        catch (IOException e) {
            this.logger.error("Encountered an I/O error whilst loading default translations", (Throwable)e);
            return;
        }
        this.tumiTranslator = TumiTranslator.create(translationsPath, this.logger, this.localeMatcher);
        this.tumiTranslator.translationStore().defaultLocale(this.configurationContainer.get().fallbackLocale());
        try {
            this.tumiTranslator.loadTranslations();
        }
        catch (IOException e) {
            this.logger.error("An error occurred loading translations", (Throwable)e);
        }
    }

    public CompletableFuture<Void> reload() {
        return this.configurationContainer.reload().thenAcceptBoth(this.messagesContainer.reload(), ($, $$) -> {
            try {
                this.reloadTranslations();
                this.tumiTranslator.translationStore().defaultLocale(this.configurationContainer.get().fallbackLocale());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void reloadTranslations() throws Exception {
        this.tumiTranslator.unregisterAll();
        this.tumiTranslator.loadTranslations();
    }

    private void processDefaultTranslations(Path translationsPath) {
        URL knownResource = TranslationCore.class.getClassLoader().getResource("translations/translations_ES.properties");
        if (knownResource == null) {
            throw new IllegalStateException("translations_ES.properties does not exist, don't know where we are");
        }
        if (knownResource.getProtocol().equals("jar")) {
            this.copyDefaultTranslationsFromJar(knownResource, translationsPath);
        } else {
            this.copyDefaultTranslationsFromFileSystem(translationsPath);
        }
    }

    private void copyTranslations(Path jarDirectoryPath, Path translationsPath) {
        try (Stream<Path> directoryStream = Files.walk(jarDirectoryPath, new FileVisitOption[0]);){
            directoryStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> this.copyTranslationFile((Path)file, translationsPath));
        }
        catch (Exception e) {
            this.logger.error("An error occurred loading default translations", (Throwable)e);
        }
    }

    private void copyTranslationFile(Path file, Path translationsFolder) {
        Path langFile = translationsFolder.resolve(file.getFileName().toString());
        if (Files.notExists(langFile, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                Files.copy(is, langFile, new CopyOption[0]);
            }
            catch (IOException e) {
                this.logger.error("An error occurred loading {} translations file", (Object)file.getFileName(), (Object)e);
            }
        }
    }

    private static String rawPathFromURL(URL url) {
        String string = url.toString();
        int index = string.indexOf(33);
        if (index == -1) {
            return string;
        }
        return string.substring(0, index);
    }

    private void copyDefaultTranslationsFromJar(URL knownResource, Path translationsPath) {
        String jarPathRaw = TranslationCore.rawPathFromURL(knownResource);
        URI path = URI.create(jarPathRaw + "!/");
        try (FileSystem fileSystem = FileSystems.newFileSystem(path, SYSTEM_PROPERTIES);){
            Path toVisit = fileSystem.getPath(translationsFolderName, new String[0]);
            if (Files.exists(toVisit, new LinkOption[0])) {
                this.copyTranslations(toVisit, translationsPath);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void copyDefaultTranslationsFromFileSystem(Path translationsPath) {
        try {
            URL url = TranslationCore.class.getClassLoader().getResource(translationsFolderName);
            if (url != null) {
                this.copyTranslations(Path.of(url.toURI()), translationsPath);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }
}

