/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.tumitranslator.core;

import io.github._4drian3d.tumitranslator.core.delegate.DelegatingTranslator;
import io.github._4drian3d.tumitranslator.core.locale.ClosestLocaleMatcher;
import io.github._4drian3d.tumitranslator.core.resolver.DelegatingTagResolver;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.Set;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.translation.MiniMessageTranslationStore;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationStore;
import net.kyori.adventure.translation.Translator;
import org.slf4j.Logger;

public record TumiTranslator(TranslationStore<String> translationStore, Set<String> loadedKeys, Set<String> loadedLocales, Path path, Logger logger, ClosestLocaleMatcher localeMatcher) {
    public static TumiTranslator create(Path path, Logger logger, ClosestLocaleMatcher localeMatcher) {
        DelegatingTranslator translationStore = new DelegatingTranslator(MiniMessageTranslationStore.create((Key)Key.key((String)"tumi", (String)"translator"), (MiniMessage)MiniMessage.builder().editTags(tags -> tags.resolver((TagResolver)new DelegatingTagResolver())).build()), localeMatcher);
        return new TumiTranslator(translationStore, new HashSet<String>(), new HashSet<String>(), path, logger, localeMatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTranslations() throws IOException {
        try (DirectoryStream<Path> directory = Files.newDirectoryStream(this.path);){
            directory.forEach(this::processFile);
        }
        finally {
            GlobalTranslator.translator().addSource(this.translationStore);
        }
    }

    private void processFile(Path file) {
        String fullFileName = file.getFileName().toString();
        String filename = com.google.common.io.Files.getNameWithoutExtension((String)fullFileName);
        String localeName = filename.replace("translations_", "");
        Locale locale = Translator.parseLocale((String)localeName);
        if (locale == null) {
            throw new UnsupportedOperationException("Not provided language | File Name: " + fullFileName);
        }
        this.loadTranslationsFromFile(fullFileName, localeName, locale, file);
    }

    private void loadTranslationsFromFile(String fullFileName, String localeName, Locale locale, Path file) {
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            PropertyResourceBundle bundle = new PropertyResourceBundle(reader);
            for (String key : bundle.keySet()) {
                this.translationStore.register(key, locale, (Object)bundle.getString(key));
                this.loadedKeys.add(key);
            }
            this.loadedLocales.add(localeName);
            this.localeMatcher.registerKnown(locale);
        }
        catch (Exception e) {
            this.logger.error("Error loading {} Translation file", (Object)fullFileName, (Object)e);
        }
    }

    public void unregisterAll() {
        GlobalTranslator.translator().removeSource(this.translationStore);
        for (String loadedKey : this.loadedKeys) {
            this.translationStore.unregister(loadedKey);
        }
        this.loadedKeys.clear();
        this.loadedLocales.clear();
    }
}

