/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.tumitranslator.core.configuration;

import io.github._4drian3d.tumitranslator.core.configuration.LocaleSerializer;
import io.github._4drian3d.tumitranslator.core.configuration.Section;
import java.nio.file.Path;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.serialize.ScalarSerializer;

public final class ConfigurationContainer<C extends Section> {
    private final AtomicReference<C> config;
    private final HoconConfigurationLoader loader;
    private final Class<C> clazz;
    private final Logger logger;

    private ConfigurationContainer(C config, Class<C> clazz, HoconConfigurationLoader loader, Logger logger) {
        this.config = new AtomicReference<C>(config);
        this.loader = loader;
        this.clazz = clazz;
        this.logger = logger;
    }

    public CompletableFuture<Void> reload() {
        return CompletableFuture.runAsync(() -> {
            try {
                CommentedConfigurationNode node = (CommentedConfigurationNode)this.loader.load();
                Section newConfig = (Section)node.get(this.clazz);
                node.set(this.clazz, (Object)newConfig);
                this.loader.save((ConfigurationNode)node);
                this.config.set(newConfig);
            }
            catch (ConfigurateException exception) {
                this.logger.error("Could not reload {} configuration file", (Object)this.clazz.getSimpleName(), (Object)exception);
                throw new RuntimeException(exception);
            }
        });
    }

    @NotNull
    public C get() {
        return (C)((Section)this.config.get());
    }

    public static <C extends Section> ConfigurationContainer<C> load(Logger logger, Path path, Class<C> clazz) {
        String configName = clazz.getSimpleName().toLowerCase(Locale.ROOT);
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().defaultOptions(opts -> opts.shouldCopyDefaults(true).header("TumiTranslator | by 4drian3d\n").serializers(builder -> builder.register((ScalarSerializer)LocaleSerializer.INSTANCE)))).path(path.resolve(configName + ".conf"))).build();
        try {
            CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
            Section config = (Section)node.get(clazz);
            node.set(clazz, (Object)config);
            loader.save((ConfigurationNode)node);
            return new ConfigurationContainer<Section>(config, clazz, loader, logger);
        }
        catch (ConfigurateException exception) {
            logger.error("Could not load {} configuration file", (Object)configName, (Object)exception);
            return null;
        }
    }
}

