/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.tumitranslator.core.locale;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
public final class ClosestLocaleMatcher {
    private final Map<String, Locale> byLanguage = new ConcurrentHashMap<String, Locale>();
    private final LoadingCache<Locale, Locale> closest = Caffeine.newBuilder().build(sublocale -> {
        String tag = sublocale.getLanguage();
        return this.byLanguage.getOrDefault(tag, (Locale)sublocale);
    });
    private static final String zhLocale = Locale.CHINESE.getLanguage();

    @Inject
    private ClosestLocaleMatcher() {
    }

    public void registerKnown(Locale locale) {
        if (locale.getLanguage().equals(zhLocale)) {
            return;
        }
        this.byLanguage.put(locale.getLanguage(), locale);
    }

    public Locale lookupClosest(Locale locale) {
        return (Locale)this.closest.get((Object)locale);
    }
}

