/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.tumitranslator.core.resolver;

import com.google.inject.Inject;
import io.github._4drian3d.tumitranslator.core.TranslationCore;
import io.github._4drian3d.tumitranslator.core.configuration.Configuration;
import io.github._4drian3d.tumitranslator.core.configuration.ConfigurationContainer;
import io.github._4drian3d.tumitranslator.core.locale.ClosestLocaleMatcher;
import io.github.miniplaceholders.api.Expansion;
import io.github.miniplaceholders.api.resolver.AudienceTagResolver;
import io.github.miniplaceholders.api.resolver.GlobalTagResolver;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.translation.Argument;
import org.jetbrains.annotations.NotNull;

public final class TumiExpansion {
    @Inject
    private TranslationCore core;
    @Inject
    private ClosestLocaleMatcher localeMatcher;
    @Inject
    private ConfigurationContainer<Configuration> configurationContainer;

    public Expansion.Builder load(Class<? extends Audience> clazz) {
        return Expansion.builder((String)"tumi").version("2.0.0").author("4drian3d").audiencePlaceholder(clazz, "translation", new TumiAudiencePlaceholder(this.core, this.localeMatcher, this.configurationContainer)).globalPlaceholder("translation_by_locale", (GlobalTagResolver)new TumiGlobalPlaceholder(this.core, this.localeMatcher, this.configurationContainer));
    }

    private record TumiAudiencePlaceholder<A extends Audience>(TranslationCore core, ClosestLocaleMatcher localeMatcher, ConfigurationContainer<Configuration> configurationContainer) implements AudienceTagResolver<A>
    {
        public Tag tag(@NotNull A audience, @NotNull ArgumentQueue queue, @NotNull Context ctx) {
            String key = queue.popOr("you need to provide a translation key").lowerValue();
            Component component = this.core.translator().translationStore().translate(Component.translatable((String)key, (ComponentLike[])new ComponentLike[]{Argument.target(audience)}), this.localeMatcher.lookupClosest(audience.get(Identity.LOCALE).orElseGet(() -> this.configurationContainer.get().fallbackLocale())));
            return component == null ? null : Tag.inserting((Component)component);
        }
    }

    private record TumiGlobalPlaceholder(TranslationCore translationCore, ClosestLocaleMatcher localeMatcher, ConfigurationContainer<Configuration> configurationContainer) implements GlobalTagResolver
    {
        public Tag tag(ArgumentQueue argumentQueue, @NotNull Context context) {
            Locale locale;
            String key = argumentQueue.popOr("you need to provide a translation key").lowerValue();
            if (argumentQueue.hasNext()) {
                Tag.Argument localeArgument = argumentQueue.pop();
                String argument = localeArgument.value().replace('_', '-');
                locale = Locale.forLanguageTag(argument);
            } else {
                locale = this.configurationContainer.get().fallbackLocale();
            }
            Component component = this.translationCore.translator().translationStore().translate(Component.translatable((String)key, context.target() == null ? List.of() : List.of(Argument.target((Pointered)context.target()))), this.localeMatcher.lookupClosest(locale));
            return component == null ? null : Tag.inserting((Component)component);
        }
    }
}

