/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.tumitranslator.libs.cloud.component.preprocessor;

import io.github._4drian3d.tumitranslator.libs.cloud.caption.Caption;
import io.github._4drian3d.tumitranslator.libs.cloud.caption.CaptionVariable;
import io.github._4drian3d.tumitranslator.libs.cloud.caption.StandardCaptionKeys;
import io.github._4drian3d.tumitranslator.libs.cloud.component.preprocessor.ComponentPreprocessor;
import io.github._4drian3d.tumitranslator.libs.cloud.context.CommandContext;
import io.github._4drian3d.tumitranslator.libs.cloud.context.CommandInput;
import io.github._4drian3d.tumitranslator.libs.cloud.parser.ArgumentParseResult;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE)
public final class RegexPreprocessor<C>
implements ComponentPreprocessor<C> {
    private final String rawPattern;
    private final Predicate<@NonNull String> predicate;
    private final Caption failureCaption;

    private RegexPreprocessor(@NonNull String pattern, @NonNull Caption failureCaption) {
        this.rawPattern = pattern;
        this.predicate = Pattern.compile(pattern).asPredicate();
        this.failureCaption = failureCaption;
    }

    public static <C> @NonNull RegexPreprocessor<C> of(@NonNull String pattern) {
        return RegexPreprocessor.of(pattern, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_REGEX);
    }

    public static <C> @NonNull RegexPreprocessor<C> of(@NonNull String pattern, @NonNull Caption failureCaption) {
        return new RegexPreprocessor<C>(pattern, failureCaption);
    }

    @Override
    public @NonNull ArgumentParseResult<Boolean> preprocess(@NonNull CommandContext<C> context, @NonNull CommandInput commandInput) {
        String head = commandInput.peekString();
        if (this.predicate.test(head)) {
            return ArgumentParseResult.success(true);
        }
        return ArgumentParseResult.failure(new RegexValidationException(this.rawPattern, head, this.failureCaption, context));
    }

    @API(status=API.Status.STABLE)
    public static final class RegexValidationException
    extends IllegalArgumentException {
        private final String pattern;
        private final String failedString;
        private final Caption failureCaption;
        private final CommandContext<?> commandContext;

        private RegexValidationException(@NonNull String pattern, @NonNull String failedString, @NonNull Caption failureCaption, @NonNull CommandContext<?> commandContext) {
            this.pattern = pattern;
            this.failedString = failedString;
            this.failureCaption = failureCaption;
            this.commandContext = commandContext;
        }

        @Override
        public String getMessage() {
            return this.commandContext.formatCaption(this.failureCaption, CaptionVariable.of("input", this.failedString), CaptionVariable.of("pattern", this.pattern));
        }

        public @NonNull String failedInput() {
            return this.failedString;
        }

        public @NonNull String pattern() {
            return this.pattern;
        }
    }
}

