/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.tumitranslator.libs.cloud.permission;

import io.github._4drian3d.tumitranslator.libs.cloud.key.CloudKey;
import io.github._4drian3d.tumitranslator.libs.cloud.key.CloudKeyHolder;
import io.github._4drian3d.tumitranslator.libs.cloud.permission.Permission;
import io.github._4drian3d.tumitranslator.libs.cloud.permission.PermissionResult;
import io.github._4drian3d.tumitranslator.libs.cloud.permission.WrappingPredicatePermission;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@FunctionalInterface
@API(status=API.Status.STABLE)
public interface PredicatePermission<C>
extends Permission,
CloudKeyHolder<Void> {
    public static <C> PredicatePermission<C> of(@NonNull CloudKey<Void> key, @NonNull Predicate<C> predicate) {
        return new WrappingPredicatePermission<C>(key, predicate);
    }

    public static <C> PredicatePermission<C> of(final @NonNull Predicate<C> predicate) {
        return new PredicatePermission<C>(){

            @Override
            public @NonNull PermissionResult testPermission(@NonNull C sender) {
                return PermissionResult.of(predicate.test(sender), this);
            }
        };
    }

    @Override
    default public @NonNull CloudKey<Void> key() {
        return CloudKey.of(this.getClass().getSimpleName());
    }

    @Override
    default public @NonNull String permissionString() {
        return this.key().name();
    }

    @API(status=API.Status.STABLE)
    public @NonNull PermissionResult testPermission(@NonNull C var1);

    @Override
    default public boolean isEmpty() {
        return false;
    }
}

