/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.tumitranslator.libs.cloud.services;

import io.github._4drian3d.tumitranslator.libs.cloud.services.PipelineException;
import io.github._4drian3d.tumitranslator.libs.cloud.services.ServiceRepository;
import io.github._4drian3d.tumitranslator.libs.cloud.services.type.Service;
import io.leangen.geantyref.TypeToken;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;

enum ServiceFilterHandler {
    INSTANCE;


    <Context> boolean passes(@NonNull ServiceRepository.ServiceWrapper<? extends Service<Context, ?>> service, @NonNull Context context) {
        if (!service.isDefaultImplementation()) {
            for (Predicate predicate : service.filters()) {
                try {
                    if (predicate.test(context)) continue;
                    return false;
                }
                catch (Exception e) {
                    throw new PipelineException(String.format("Failed to evaluate filter '%s' for '%s'", TypeToken.get(predicate.getClass()).getType().getTypeName(), service), e);
                }
            }
        }
        return true;
    }
}

