/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.tumitranslator.libs.cloud.velocity.parser;

import com.velocitypowered.api.proxy.server.RegisteredServer;
import io.github._4drian3d.tumitranslator.libs.cloud.caption.CaptionVariable;
import io.github._4drian3d.tumitranslator.libs.cloud.component.CommandComponent;
import io.github._4drian3d.tumitranslator.libs.cloud.context.CommandContext;
import io.github._4drian3d.tumitranslator.libs.cloud.context.CommandInput;
import io.github._4drian3d.tumitranslator.libs.cloud.exception.parsing.ParserException;
import io.github._4drian3d.tumitranslator.libs.cloud.parser.ArgumentParseResult;
import io.github._4drian3d.tumitranslator.libs.cloud.parser.ArgumentParser;
import io.github._4drian3d.tumitranslator.libs.cloud.parser.ParserDescriptor;
import io.github._4drian3d.tumitranslator.libs.cloud.suggestion.BlockingSuggestionProvider;
import io.github._4drian3d.tumitranslator.libs.cloud.velocity.VelocityCaptionKeys;
import io.github._4drian3d.tumitranslator.libs.cloud.velocity.VelocityContextKeys;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ServerParser<C>
implements ArgumentParser<C, RegisteredServer>,
BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, RegisteredServer> serverParser() {
        return ParserDescriptor.of(new ServerParser<C>(), RegisteredServer.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, RegisteredServer> serverComponent() {
        return CommandComponent.builder().parser(ServerParser.serverParser());
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull RegisteredServer> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        RegisteredServer server = commandContext.get(VelocityContextKeys.PROXY_SERVER_KEY).getServer(input).orElse(null);
        if (server == null) {
            return ArgumentParseResult.failure(new ServerParseException(input, commandContext));
        }
        return ArgumentParseResult.success(server);
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return commandContext.get(VelocityContextKeys.PROXY_SERVER_KEY).getAllServers().stream().map(s -> s.getServerInfo().getName()).collect(Collectors.toList());
    }

    public static final class ServerParseException
    extends ParserException {
        private ServerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(ServerParser.class, context, VelocityCaptionKeys.ARGUMENT_PARSE_FAILURE_SERVER, CaptionVariable.of("input", input));
        }
    }
}

