/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.tumitranslator.velocity;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.PluginManager;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import io.github._4drian3d.tumitranslator.core.TranslationCore;
import io.github._4drian3d.tumitranslator.core.TumiTranslator;
import io.github._4drian3d.tumitranslator.core.command.TumiCommand;
import io.github._4drian3d.tumitranslator.core.modules.TumiModule;
import io.github._4drian3d.tumitranslator.core.resolver.TumiExpansion;
import io.github._4drian3d.tumitranslator.libs.cloud.CommandManager;
import io.github._4drian3d.tumitranslator.libs.cloud.SenderMapper;
import io.github._4drian3d.tumitranslator.libs.cloud.execution.ExecutionCoordinator;
import io.github._4drian3d.tumitranslator.libs.cloud.velocity.VelocityCommandManager;
import io.github.miniplaceholders.api.Expansion;
import java.nio.file.Path;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

@Plugin(id="tumitranslator", name="TumiTranslator", description="Rich Translations for your server", version="2.0.0", authors={"4drian3d"}, dependencies={@Dependency(id="miniplaceholders")})
public final class VelocityPlugin {
    @Inject
    private Injector injector;
    @Inject
    @DataDirectory
    private Path path;
    @Inject
    private PluginContainer container;
    @Inject
    private ProxyServer proxyServer;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private ComponentLogger logger;

    @Subscribe
    void onProxyInitialization(ProxyInitializeEvent event) {
        VelocityCommandManager commandManager = new VelocityCommandManager(this.container, this.proxyServer, ExecutionCoordinator.asyncCoordinator(), SenderMapper.identity());
        Injector childInjector = this.injector.createChildInjector(new Module[]{new TumiModule(this.path), binder -> {
            binder.bind((TypeLiteral)new TypeLiteral<Object>(this){}).toInstance((Object)commandManager);
            binder.bind((TypeLiteral)new TypeLiteral<CommandManager<CommandSource>>(this){}).toInstance((Object)commandManager);
        }});
        TranslationCore core = (TranslationCore)childInjector.getInstance(TranslationCore.class);
        core.loadTranslations();
        ((TumiCommand)childInjector.getInstance(Key.get((TypeLiteral)new TypeLiteral<TumiCommand<CommandSource>>(this){}))).register("vtumitranslator");
        ((Expansion)((TumiExpansion)childInjector.getInstance(TumiExpansion.class)).load(Player.class).build()).register();
        TumiTranslator translator = core.translator();
        this.logger.info(MiniMessage.miniMessage().deserialize(core.messagesContainer().get().enable(), new TagResolver[]{Placeholder.unparsed((String)"files", (String)Integer.toString(core.translator().loadedLocales().size())), Placeholder.parsed((String)"default_locale", (String)core.configurationContainer().get().fallbackLocale().toString())}));
    }
}

