/*
 * Decompiled with CFR 0.152.
 */
package com.example.heartmod;

import com.example.heartmod.HeartModConfig;
import com.example.heartmod.command.HeartModCommand;
import com.example.heartmod.item.ModItems;
import com.example.heartmod.loot.ModLoot;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1324;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_8779;
import net.minecraft.server.MinecraftServer;

public class HeartMod
implements ModInitializer {
    public static final String MOD_ID = "heartmod";
    private static HeartMod INSTANCE;
    private final HeartModConfig config = new HeartModConfig();
    private final Map<class_3222, Integer> previousCrystalCounts = new HashMap<class_3222, Integer>();
    private final Map<class_3222, Integer> bandagesUsed = new HashMap<class_3222, Integer>();
    private final Map<class_3222, Integer> enhancedBandagesUsed = new HashMap<class_3222, Integer>();
    private int tickCounter = 0;

    public static HeartMod getInstance() {
        return INSTANCE;
    }

    public void onInitialize() {
        INSTANCE = this;
        System.out.println("[HeartMod] \u2705 Initialization started...");
        ModItems.registerItems();
        ModLoot.register();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            class_1928.class_4310 regenRule = (class_1928.class_4310)server.method_3767().method_20746(class_1928.field_19395);
            if (regenRule.method_20753()) {
                regenRule.method_20758(false, server);
                System.out.println("[HeartMod] \u2699\ufe0f Disabled natural regeneration (gamerule).");
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> this.updateHealthFromCrystals(newPlayer));
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> this.updateHealthFromCrystals(newPlayer));
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            ++this.tickCounter;
            if (this.tickCounter >= this.config.getTickInterval()) {
                this.tickCounter = 0;
                for (class_3222 player : server.method_3760().method_14571()) {
                    this.updateHealthFromCrystalsTick(player);
                    this.updateHeartAchievements(player, server);
                }
            }
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            for (class_3222 player : world.method_18456()) {
                class_238 searchArea = new class_238(player.method_24515()).method_1014(10.0);
                List entities = world.method_8390(class_1542.class, searchArea, class_1297::method_5771);
                for (class_1542 entity : entities) {
                    class_1297 patt0$temp;
                    class_1799 stack = entity.method_6983();
                    if (stack.method_7909() != ModItems.HEART_CRYSTAL || !((patt0$temp = entity.method_24921()) instanceof class_3222)) continue;
                    class_3222 owner = (class_3222)patt0$temp;
                    HeartMod.getInstance().grantAdvancement(owner, "broken_heart", "threw_heart_in_lava");
                    entity.method_31472();
                    System.out.println("[HeartMod] \u2764\ufe0f " + owner.method_5477().getString() + " threw a heart into lava!");
                }
            }
        });
        HeartModCommand.register(this);
        System.out.println("[HeartMod] \u2705 Initialization complete!");
    }

    public void handleBandageUse(class_3222 player) {
        int used = this.bandagesUsed.getOrDefault(player, 0) + 1;
        this.bandagesUsed.put(player, used);
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return;
        }
        if (used >= 1) {
            this.grantAdvancement(player, "collect_bandage_1", "use_1");
        }
        if (used >= 16) {
            this.grantAdvancement(player, "collect_bandage_16", "use_16");
        }
        if (used >= 64) {
            this.grantAdvancement(player, "collect_bandage_64", "use_64");
        }
    }

    public void handleEnhancedBandageUse(class_3222 player) {
        int used = this.enhancedBandagesUsed.getOrDefault(player, 0) + 1;
        this.enhancedBandagesUsed.put(player, used);
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return;
        }
        if (used >= 1) {
            this.grantAdvancement(player, "use_enhanced_bandage_1", "use_1");
        }
        if (used >= 8) {
            this.grantAdvancement(player, "use_enhanced_bandage_8", "use_8");
        }
        if (used >= 32) {
            this.grantAdvancement(player, "use_enhanced_bandage_32", "use_32");
        }
    }

    public void grantAdvancement(class_3222 player, String advancementId, String criterion) {
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return;
        }
        class_2960 id = class_2960.method_60655((String)MOD_ID, (String)advancementId);
        class_8779 advEntry = server.method_3851().method_12896(id);
        if (advEntry == null) {
            System.out.println("[HeartMod] \u26a0\ufe0f Advancement not found: " + String.valueOf(id));
            return;
        }
        player.method_14236().method_12878(advEntry, criterion);
        System.out.println("[HeartMod] \ud83c\udfc6 Granted advancement: " + String.valueOf(id) + " (" + criterion + ")");
    }

    private void updateHealthFromCrystalsTick(class_3222 player) {
        int crystalCount = this.countCrystals(player);
        Integer previousCount = this.previousCrystalCounts.get(player);
        if (previousCount == null || previousCount != crystalCount) {
            this.previousCrystalCounts.put(player, crystalCount);
            this.updateHealthFromCrystals(player);
        }
    }

    public void updateHealthFromCrystals(class_3222 player) {
        int crystalCount = this.countCrystals(player);
        double newMaxHealth = this.config.getBaseHearts() + crystalCount * this.config.getHeartsPerItem();
        class_1324 maxHealth = player.method_5996(class_5134.field_23716);
        if (maxHealth != null && maxHealth.method_6201() != newMaxHealth) {
            maxHealth.method_6192(newMaxHealth);
            if ((double)player.method_6032() > newMaxHealth) {
                player.method_6033((float)newMaxHealth);
            }
        }
    }

    private int countCrystals(class_3222 player) {
        int count = 0;
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7909() != this.config.getHeartItem()) continue;
            count += stack.method_7947();
        }
        return count;
    }

    private void updateHeartAchievements(class_3222 player, MinecraftServer server) {
        int[] thresholds;
        int currentHearts = (int)(Objects.requireNonNull(player.method_5996(class_5134.field_23716)).method_6201() / 2.0);
        for (int t : thresholds = new int[]{10, 11, 20, 40}) {
            if (currentHearts < t) continue;
            class_2960 id = class_2960.method_60655((String)MOD_ID, (String)("collect_" + t + "_hearts"));
            class_8779 advEntry = server.method_3851().method_12896(id);
            if (advEntry != null) {
                player.method_14236().method_12878(advEntry, "collect_" + t);
                continue;
            }
            System.out.println("[HeartMod] \u26a0\ufe0f Advancement not found: " + String.valueOf(id));
        }
    }

    public HeartModConfig getConfig() {
        return this.config;
    }
}

