/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.ability.impl.generic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import tocraft.craftedcore.patched.CRegistries;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.GenericShapeAbility;

public class ShootFireballAbility<T extends LivingEntity>
extends GenericShapeAbility<T> {
    public static final ResourceLocation ID = Walkers.id("shoot_fireball");
    public static final MapCodec<ShootFireballAbility<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.f_135803_.optionalFieldOf("icon").forGetter(o -> {
        if (o.icon == Items.f_42613_) {
            return Optional.empty();
        }
        return Optional.ofNullable(CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"item")).m_7981_((Object)o.icon));
    }), (App)Codec.BOOL.fieldOf("is_large").forGetter(o -> o.isLarge)).apply((Applicative)instance, instance.stable((icon, isLarge) -> icon.map(resourceLocation -> new ShootFireballAbility((Item)CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"item")).m_7745_(resourceLocation), (boolean)isLarge)).orElseGet(() -> new ShootFireballAbility((boolean)isLarge)))));
    private final boolean isLarge;
    private final Item icon;

    public ShootFireballAbility(boolean isLarge) {
        this(Items.f_42613_, isLarge);
    }

    public ShootFireballAbility(Item icon, boolean isLarge) {
        this.icon = icon;
        this.isLarge = isLarge;
    }

    @Override
    public void onUse(Player player, T shape, Level world) {
        Fireball fireball = this.getFireball(player, world);
        world.m_7967_((Entity)fireball);
        if (shape instanceof Blaze) {
            world.m_6269_(null, (Entity)player, SoundEvents.f_11705_, SoundSource.HOSTILE, 2.0f, (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.2f + 1.0f);
        } else if (shape instanceof Ghast) {
            world.m_6269_(null, (Entity)player, SoundEvents.f_11923_, SoundSource.HOSTILE, 10.0f, (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.2f + 1.0f);
            world.m_6269_(null, (Entity)player, SoundEvents.f_11924_, SoundSource.HOSTILE, 10.0f, (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.2f + 1.0f);
        } else {
            world.m_6269_(null, (Entity)player, SoundEvents.f_11874_, SoundSource.HOSTILE, 2.0f, (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @NotNull
    private Fireball getFireball(Player player, Level world) {
        LargeFireball fireball;
        if (this.isLarge) {
            fireball = new LargeFireball(world, (LivingEntity)player, player.m_20154_().f_82479_, player.m_20154_().f_82480_, player.m_20154_().f_82481_, 2);
            fireball.m_7678_(fireball.m_20185_(), fireball.m_20186_() + 1.75, fireball.m_20189_(), fireball.m_146908_(), fireball.m_146909_());
            fireball.m_20248_(fireball.m_20185_(), fireball.m_20186_(), fireball.m_20189_());
        } else {
            fireball = new SmallFireball(world, player.m_20185_(), player.m_20188_(), player.m_20189_(), player.m_20154_().f_82479_, player.m_20154_().f_82480_, player.m_20154_().f_82481_);
        }
        fireball.m_5602_((Entity)player);
        return fireball;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends GenericShapeAbility<?>> codec() {
        return CODEC;
    }

    @Override
    public Item getIcon() {
        return this.icon;
    }
}

