/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.variant;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.impl.variant.AxolotlTypeProvider;
import tocraft.walkers.impl.variant.CatTypeProvider;
import tocraft.walkers.impl.variant.CreeperTypeProvider;
import tocraft.walkers.impl.variant.FoxTypeProvider;
import tocraft.walkers.impl.variant.HorseTypeProvider;
import tocraft.walkers.impl.variant.LlamaTypeProvider;
import tocraft.walkers.impl.variant.MagmaCubeTypeProvider;
import tocraft.walkers.impl.variant.MushroomCowTypeProvider;
import tocraft.walkers.impl.variant.PandaTypeProvider;
import tocraft.walkers.impl.variant.ParrotTypeProvider;
import tocraft.walkers.impl.variant.RabbitTypeProvider;
import tocraft.walkers.impl.variant.SheepTypeProvider;
import tocraft.walkers.impl.variant.ShulkerTypeProvider;
import tocraft.walkers.impl.variant.SlimeTypeProvider;
import tocraft.walkers.impl.variant.TropicalFishTypeProvider;
import tocraft.walkers.impl.variant.VillagerTypeProvider;
import tocraft.walkers.impl.variant.ZombieVillagerTypeProvider;
import tocraft.walkers.integrations.Integrations;

public class TypeProviderRegistry {
    private static final Map<EntityType<? extends LivingEntity>, TypeProvider<? extends LivingEntity>> VARIANT_BY_TYPE = new LinkedHashMap<EntityType<? extends LivingEntity>, TypeProvider<? extends LivingEntity>>();

    @ApiStatus.Internal
    public static void registerDefault() {
        TypeProviderRegistry.register(EntityType.f_20558_, new CreeperTypeProvider());
        TypeProviderRegistry.register(EntityType.f_20520_, new SheepTypeProvider());
        TypeProviderRegistry.register(EntityType.f_147039_, new AxolotlTypeProvider());
        TypeProviderRegistry.register(EntityType.f_20508_, new ParrotTypeProvider());
        TypeProviderRegistry.register(EntityType.f_20452_, new FoxTypeProvider());
        TypeProviderRegistry.register(EntityType.f_20553_, new CatTypeProvider());
        TypeProviderRegistry.register(EntityType.f_20526_, new SlimeTypeProvider());
        TypeProviderRegistry.register(EntityType.f_20457_, new HorseTypeProvider());
        TypeProviderRegistry.register(EntityType.f_20466_, new LlamaTypeProvider());
        TypeProviderRegistry.register(EntityType.f_20488_, new LlamaTypeProvider());
        TypeProviderRegistry.register(EntityType.f_20468_, new MagmaCubeTypeProvider());
        TypeProviderRegistry.register(EntityType.f_20504_, new MushroomCowTypeProvider());
        TypeProviderRegistry.register(EntityType.f_20507_, new PandaTypeProvider());
        TypeProviderRegistry.register(EntityType.f_20517_, new RabbitTypeProvider());
        TypeProviderRegistry.register(EntityType.f_20492_, new VillagerTypeProvider());
        TypeProviderRegistry.register(EntityType.f_20530_, new ZombieVillagerTypeProvider());
        TypeProviderRegistry.register(EntityType.f_20489_, new TropicalFishTypeProvider());
        TypeProviderRegistry.register(EntityType.f_20521_, new ShulkerTypeProvider());
        Integrations.registerTypeProvider();
    }

    public static <T extends LivingEntity> void register(EntityType<T> type, TypeProvider<T> provider) {
        VARIANT_BY_TYPE.put(type, provider);
    }

    public static <T extends LivingEntity> boolean hasProvider(EntityType<T> type) {
        return VARIANT_BY_TYPE.containsKey(type);
    }

    @Nullable
    public static <T extends LivingEntity> TypeProvider<T> getProvider(EntityType<T> type) {
        return VARIANT_BY_TYPE.get(type);
    }

    @ApiStatus.Internal
    public static List<Pair<EntityType<? extends LivingEntity>, TypeProvider<?>>> getAll() {
        ArrayList typeList = new ArrayList();
        VARIANT_BY_TYPE.forEach((entityType, typeProvider) -> typeList.add(new Pair(entityType, typeProvider)));
        return typeList;
    }

    @ApiStatus.Internal
    public static void clearAll() {
        VARIANT_BY_TYPE.clear();
    }
}

