/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.event.common.CommandEvents;
import tocraft.craftedcore.patched.CCommandSourceStack;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.CEntitySummonArgument;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerAbilities;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.command.EntityBlacklistCommands;
import tocraft.walkers.command.PlayerBlacklistCommands;
import tocraft.walkers.impl.PlayerDataProvider;

public class WalkersCommand {
    public static void initialize() {
        CommandEvents.REGISTRATION.register((dispatcher, ctx) -> WalkersCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher));
    }

    private static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        Object ctx = null;
        LiteralCommandNode rootNode = ((LiteralArgumentBuilder)Commands.m_82127_((String)"walkers").requires(source -> source.m_6761_(2))).build();
        LiteralCommandNode remove2ndShape = ((LiteralArgumentBuilder)Commands.m_82127_((String)"remove2ndShape").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(context -> {
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)context, (String)"players")) {
                WalkersCommand.remove2ndShape((CommandSourceStack)context.getSource(), player);
            }
            return 1;
        }))).build();
        LiteralCommandNode change2ndShape = ((LiteralArgumentBuilder)Commands.m_82127_((String)"change2ndShape").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            Entity entity = EntityArgument.m_91452_((CommandContext)context, (String)"entity");
            CompoundTag nbt = new CompoundTag();
            entity.m_20240_(nbt);
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)context, (String)"players")) {
                WalkersCommand.change2ndShape((CommandSourceStack)context.getSource(), player, EntityType.m_20613_((EntityType)entity.m_6095_()), nbt);
            }
            return 1;
        }))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"shape", (ArgumentType)CEntitySummonArgument.id(ctx)).suggests(SuggestionProviders.f_121645_).executes(context -> {
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)context, (String)"players")) {
                WalkersCommand.change2ndShape((CommandSourceStack)context.getSource(), player, CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), null);
            }
            return 1;
        })).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> {
            CompoundTag nbt = CompoundTagArgument.m_87660_((CommandContext)context, (String)"nbt");
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)context, (String)"players")) {
                WalkersCommand.change2ndShape((CommandSourceStack)context.getSource(), player, CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), nbt);
            }
            return 1;
        }))))).build();
        LiteralCommandNode switchShape = ((LiteralArgumentBuilder)Commands.m_82127_((String)"switchShape").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"normal").executes(context -> {
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)context, (String)"players")) {
                WalkersCommand.switchShapeToNormal((CommandSourceStack)context.getSource(), player);
            }
            return 1;
        }))).then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            Entity entity = EntityArgument.m_91452_((CommandContext)context, (String)"entity");
            CompoundTag nbt = new CompoundTag();
            entity.m_20240_(nbt);
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)context, (String)"players")) {
                WalkersCommand.switchShape((CommandSourceStack)context.getSource(), player, EntityType.m_20613_((EntityType)entity.m_6095_()), nbt);
            }
            return 1;
        }))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"shape", (ArgumentType)CEntitySummonArgument.id(ctx)).suggests(SuggestionProviders.f_121645_).executes(context -> {
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)context, (String)"players")) {
                WalkersCommand.switchShape((CommandSourceStack)context.getSource(), player, CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), null);
            }
            return 1;
        })).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> {
            CompoundTag nbt = CompoundTagArgument.m_87660_((CommandContext)context, (String)"nbt");
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)context, (String)"players")) {
                WalkersCommand.switchShape((CommandSourceStack)context.getSource(), player, CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"shape"), nbt);
            }
            return 1;
        }))))).build();
        LiteralCommandNode show2ndShape = ((LiteralArgumentBuilder)Commands.m_82127_((String)"show2ndShape").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(context -> {
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)context, (String)"players")) {
                WalkersCommand.show2ndShape((CommandSourceStack)context.getSource(), player);
            }
            return 1;
        }))).build();
        rootNode.addChild((CommandNode)remove2ndShape);
        rootNode.addChild((CommandNode)change2ndShape);
        rootNode.addChild((CommandNode)switchShape);
        rootNode.addChild((CommandNode)show2ndShape);
        rootNode.addChild(PlayerBlacklistCommands.getRootNode());
        rootNode.addChild(EntityBlacklistCommands.getRootNode());
        dispatcher.getRoot().addChild((CommandNode)rootNode);
    }

    private static void show2ndShape(CommandSourceStack source, ServerPlayer player) {
        if (((PlayerDataProvider)player).walkers$get2ndShape() != null) {
            ShapeType<?> type = ((PlayerDataProvider)player).walkers$get2ndShape();
            if (type != null) {
                CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.show2ndShapeNot_positive", (Object[])new Object[]{player.m_5446_(), ShapeType.createTooltipText(type.create(CEntity.level((Entity)player), (Player)player))}), (boolean)false);
            }
        } else {
            CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.show2ndShapeNot_failed", (Object[])new Object[]{player.m_5446_()}), (boolean)false);
        }
    }

    private static void remove2ndShape(CommandSourceStack source, ServerPlayer player) {
        WalkersCommand.change2ndShape(player, null);
        player.m_5661_((Component)TComponent.translatable((String)"walkers.remove_entity", (Object[])new Object[0]), true);
        CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.deletion_success", (Object[])new Object[]{player.m_5446_()}), (boolean)false);
    }

    private static void change2ndShape(CommandSourceStack source, ServerPlayer player, ResourceLocation id, @Nullable CompoundTag nbt) {
        ShapeType<EntityType> type = ShapeType.from((EntityType)Walkers.getEntityTypeRegistry().m_7745_(id));
        MutableComponent name = TComponent.translatable((String)type.getEntityType().m_20675_(), (Object[])new Object[0]);
        if (nbt != null) {
            CompoundTag copy = nbt.m_6426_();
            copy.m_128359_("id", id.toString());
            ServerLevel serverWorld = source.m_81372_();
            Entity loaded = EntityType.m_20645_((CompoundTag)copy, (Level)serverWorld, it -> it);
            if (loaded instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)loaded;
                type = ShapeType.from(living);
                name = ShapeType.createTooltipText(living);
            }
        }
        if (((PlayerDataProvider)player).walkers$get2ndShape() != type) {
            WalkersCommand.change2ndShape(player, type);
            player.m_5661_((Component)TComponent.translatable((String)"walkers.unlock_entity", (Object[])new Object[]{name}), false);
            CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.grant_success", (Object[])new Object[]{name, player.m_5446_()}), (boolean)false);
        } else {
            CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.already_has", (Object[])new Object[]{player.m_5446_(), name}), (boolean)false);
        }
    }

    private static void switchShape(CommandSourceStack source, ServerPlayer player, ResourceLocation shape, @Nullable CompoundTag nbt) {
        Entity created;
        if (nbt != null) {
            CompoundTag copy = nbt.m_6426_();
            copy.m_128359_("id", shape.toString());
            ServerLevel serverWorld = source.m_81372_();
            created = EntityType.m_20645_((CompoundTag)copy, (Level)serverWorld, it -> it);
        } else {
            EntityType entity = (EntityType)Walkers.getEntityTypeRegistry().m_7745_(shape);
            created = entity.m_20615_(CEntity.level((Entity)player));
        }
        if (created instanceof LivingEntity) {
            ((PlayerDataProvider)player).walkers$updateShapes((LivingEntity)created);
            CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.switchShape_success", (Object[])new Object[]{player.m_5446_(), TComponent.translatable((String)created.m_6095_().m_20675_(), (Object[])new Object[0])}), (boolean)false);
        }
    }

    private static void switchShapeToNormal(CommandSourceStack source, ServerPlayer player) {
        boolean result = PlayerShape.updateShapes(player, null);
        if (result) {
            CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.switchShape_human_success", (Object[])new Object[]{player.m_5446_()}), (boolean)false);
        }
    }

    private static void change2ndShape(ServerPlayer player, ShapeType<?> newShape) {
        ((PlayerDataProvider)player).walkers$set2ndShape(newShape);
        PlayerShapeChanger.sync(player);
        PlayerAbilities.sync(player);
    }
}

