/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.ability.impl.generic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import tocraft.craftedcore.patched.CRegistries;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.GenericShapeAbility;

public class ThrowPotionsAbility<T extends LivingEntity>
extends GenericShapeAbility<T> {
    public static final List<Potion> VALID_POTIONS = Arrays.asList(Potions.f_43582_, Potions.f_43584_, Potions.f_43615_, Potions.f_43593_);
    private final List<Potion> validPotions;
    public static final ResourceLocation ID = Walkers.id("throw_potion");
    public static final MapCodec<ThrowPotionsAbility<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("potions", VALID_POTIONS.stream().map(o -> CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"potion")).m_7981_(o)).toList()).forGetter(o -> o.validPotions.stream().map(o1 -> CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"potion")).m_7981_(o1)).toList())).apply((Applicative)instance, instance.stable(validPotions -> new ThrowPotionsAbility(validPotions.stream().map(o -> (Potion)CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"potion")).m_7745_(o)).toList()))));

    public ThrowPotionsAbility(List<Potion> validPotions) {
        this.validPotions = validPotions;
    }

    public ThrowPotionsAbility() {
        this(VALID_POTIONS);
    }

    @Override
    public void onUse(Player player, T shape, Level world) {
        ThrownPotion potionEntity = new ThrownPotion(world, (LivingEntity)player);
        potionEntity.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)this.validPotions.get(world.f_46441_.m_188503_(this.validPotions.size()))));
        potionEntity.m_146926_(-20.0f);
        Vec3 rotation = player.m_20154_();
        potionEntity.m_6686_(rotation.m_7096_(), rotation.m_7098_(), rotation.m_7094_(), 0.75f, 8.0f);
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12553_, player.m_5720_(), 1.0f, 0.8f + world.f_46441_.m_188501_() * 0.4f);
        world.m_7967_((Entity)potionEntity);
    }

    @Override
    public Item getIcon() {
        return Items.f_42589_;
    }

    @Override
    public int getDefaultCooldown() {
        return 200;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends GenericShapeAbility<?>> codec() {
        return CODEC;
    }
}

