/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.ability.impl.specific;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.ShapeAbility;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.mixin.EntityTrackerAccessor;
import tocraft.walkers.mixin.ThreadedAnvilChunkStorageAccessor;

public class AngerAbility<T extends Mob>
extends ShapeAbility<T> {
    public static final ResourceLocation ID = Walkers.id("anger");
    private final SoundEvent notAggressiveSound;
    private final SoundEvent aggressiveSound;
    private final Item icon;

    public AngerAbility() {
        this(SoundEvents.f_12320_, SoundEvents.f_12313_);
    }

    public AngerAbility(SoundEvent notAggressiveSound, SoundEvent aggressionSound) {
        this(notAggressiveSound, aggressionSound, Items.f_42497_);
    }

    public AngerAbility(SoundEvent notAggressiveSound, SoundEvent aggressionSound, Item icon) {
        this.notAggressiveSound = notAggressiveSound;
        this.aggressiveSound = aggressionSound;
        this.icon = icon;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void onUse(Player player, T oShape, Level world) {
        if (oShape instanceof NeutralMob) {
            NeutralMob shape = (NeutralMob)oShape;
            if (shape.m_21660_()) {
                shape.m_21662_();
                world.m_6269_(null, (Entity)player, this.notAggressiveSound, SoundSource.PLAYERS, 1.0f, (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.2f + 1.0f);
            } else {
                shape.m_6825_();
                world.m_6269_(null, (Entity)player, this.aggressiveSound, SoundSource.PLAYERS, 1.0f, (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.2f + 1.0f);
            }
            if (!world.m_5776_()) {
                Int2ObjectMap<Object> trackers = ((ThreadedAnvilChunkStorageAccessor)((ServerLevel)world).m_7726_().f_8325_).getEntityMap();
                Object tracking = trackers.get(player.m_19879_());
                ((EntityTrackerAccessor)tracking).getSeenBy().forEach(listener -> PlayerShape.sync((ServerPlayer)player, listener.m_142253_()));
            }
        } else {
            Walkers.LOGGER.error("{}: Registered for unvalid entity {}!", (Object)AngerAbility.class.getSimpleName(), (Object)EntityType.m_20613_((EntityType)oShape.m_6095_()));
        }
    }

    @Override
    public Item getIcon() {
        return this.icon;
    }
}

