/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.data.blacklist;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import tocraft.craftedcore.data.SynchronizedJsonReloadListener;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.blacklist.EntityBlacklist;

public class EntityBlacklistDataManager
extends SynchronizedJsonReloadListener {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create();
    public static Codec<Pair<List<ResourceLocation>, List<ResourceLocation>>> BLACKLIST_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("entity_types", new ArrayList()).forGetter(Pair::getFirst), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("entity_tags", new ArrayList()).forGetter(Pair::getSecond)).apply((Applicative)instance, instance.stable(Pair::new)));

    public EntityBlacklistDataManager() {
        super(GSON, "walkers");
    }

    protected void onApply(Map<ResourceLocation, JsonElement> map) {
        EntityBlacklist.clearAll();
        EntityBlacklist.registerDefault();
        for (Map.Entry<ResourceLocation, JsonElement> mapEntry : map.entrySet()) {
            if (!mapEntry.getKey().m_135815_().equals("blacklist")) continue;
            Pair<List<ResourceLocation>, List<ResourceLocation>> someBlacklist = EntityBlacklistDataManager.blacklistFromJson(mapEntry.getValue().getAsJsonObject());
            for (ResourceLocation resourceLocation : (List)someBlacklist.getFirst()) {
                if (!Walkers.getEntityTypeRegistry().m_7804_(resourceLocation)) continue;
                EntityBlacklist.registerByType((EntityType)Walkers.getEntityTypeRegistry().m_7745_(resourceLocation));
            }
            for (ResourceLocation resourceLocation : (List)someBlacklist.getSecond()) {
                EntityBlacklist.registerByTag(TagKey.m_203882_((ResourceKey)Walkers.getEntityTypeRegistry().m_123023_(), (ResourceLocation)resourceLocation));
            }
        }
    }

    protected static Pair<List<ResourceLocation>, List<ResourceLocation>> blacklistFromJson(JsonObject json) {
        return (Pair)BLACKLIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, msg -> {
            throw new JsonParseException(msg);
        });
    }
}

