/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.forge;

import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import tocraft.walkers.Walkers;
import tocraft.walkers.WalkersClient;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.AquaticTrait;
import tocraft.walkers.traits.impl.FlyingTrait;

@Mod(value="walkers")
public class WalkersForge {
    public WalkersForge() {
        new Walkers().initialize();
        if (FMLEnvironment.dist.isClient()) {
            new WalkersClient().initialize();
        }
        MinecraftForge.EVENT_BUS.addListener(this::event);
    }

    private void event(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (!player.m_20096_()) {
            if (TraitRegistry.has(PlayerShape.getCurrentShape(player), FlyingTrait.ID)) {
                event.setNewSpeed(event.getNewSpeed() * 5.0f);
            } else if (player.m_204029_(FluidTags.f_13131_)) {
                for (ShapeTrait<LivingEntity> aquaticTrait : TraitRegistry.get(PlayerShape.getCurrentShape(player), AquaticTrait.ID)) {
                    if (!((AquaticTrait)aquaticTrait).isAquatic) continue;
                    event.setNewSpeed(event.getNewSpeed() * 5.0f);
                    break;
                }
            }
        }
        if (player.m_204029_(FluidTags.f_13131_) && !EnchantmentHelper.m_44934_((LivingEntity)player)) {
            for (ShapeTrait<LivingEntity> aquaticTrait : TraitRegistry.get(PlayerShape.getCurrentShape(player), AquaticTrait.ID)) {
                if (!((AquaticTrait)aquaticTrait).isAquatic) continue;
                event.setNewSpeed(event.getNewSpeed() * 5.0f);
                break;
            }
        }
    }
}

