/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.impl.variant;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.level.Level;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.api.variant.TypeProvider;

public class FrogTypeProvider
extends TypeProvider<Frog> {
    private static final Map<Integer, String> PREFIX_BY_ID = ImmutableMap.builder().put((Object)0, (Object)"Temperate").put((Object)1, (Object)"Warm").put((Object)2, (Object)"Cold").build();

    @Override
    public int getVariantData(Frog entity) {
        return BuiltInRegistries.f_256770_.m_7447_((Object)entity.m_28554_());
    }

    @Override
    public Frog create(EntityType<Frog> type, Level world, int data) {
        Frog frog = new Frog(type, world);
        frog.m_28464_(BuiltInRegistries.f_256770_.m_203300_(data).map(Holder.Reference::m_203334_).orElse(FrogVariant.f_218185_));
        return frog;
    }

    @Override
    public int getFallbackData() {
        return 0;
    }

    @Override
    public int getRange() {
        return BuiltInRegistries.f_256770_.m_13562_() - 1;
    }

    @Override
    public Component modifyText(Frog frog, MutableComponent text) {
        int variant = this.getVariantData(frog);
        return TComponent.literal((String)(PREFIX_BY_ID.containsKey(variant) ? PREFIX_BY_ID.get(variant) + " " : "")).m_7220_((Component)text);
    }
}

