/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.traits.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.traits.ShapeTrait;

public class CantInteractTrait<E extends LivingEntity>
extends ShapeTrait<E> {
    public static final ResourceLocation ID = Walkers.id("cant_interact");
    public static final MapCodec<CantInteractTrait<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("can_only_interact_with_listed", (Object)false).forGetter(o -> o.canOnlyInteractWithListed), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("types", new ArrayList()).forGetter(o -> o.types.stream().map(o1 -> EntityType.m_20613_((EntityType)o1)).toList()), (App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("tags", new ArrayList()).forGetter(o -> o.tags.stream().map(TagKey::f_203868_).toList())).apply((Applicative)instance, instance.stable((canOnlyInteractWithListed, typeIds, tagIds) -> {
        ArrayList reinforcements = new ArrayList();
        ArrayList reinforcementTags = new ArrayList();
        for (ResourceLocation resourceLocation : typeIds) {
            if (!Walkers.getEntityTypeRegistry().m_7804_(resourceLocation)) continue;
            reinforcements.add((EntityType)Walkers.getEntityTypeRegistry().m_7745_(resourceLocation));
        }
        for (ResourceLocation resourceLocation : tagIds) {
            reinforcementTags.add(TagKey.m_203882_((ResourceKey)Walkers.getEntityTypeRegistry().m_123023_(), (ResourceLocation)resourceLocation));
        }
        return new CantInteractTrait((boolean)canOnlyInteractWithListed, (List<EntityType<?>>)reinforcements, (List<TagKey<EntityType<?>>>)reinforcementTags);
    })));
    private final boolean canOnlyInteractWithListed;
    private final List<Class<? extends Entity>> classes;
    private final List<EntityType<?>> types;
    private final List<TagKey<EntityType<?>>> tags;

    public CantInteractTrait(@NotNull List<EntityType<?>> types, @NotNull List<TagKey<EntityType<?>>> tags) {
        this(false, new ArrayList<Class<? extends Entity>>(), types, tags);
    }

    public CantInteractTrait(boolean canOnlyInteractWithListed, @NotNull List<EntityType<?>> types, @NotNull List<TagKey<EntityType<?>>> tags) {
        this(canOnlyInteractWithListed, new ArrayList<Class<? extends Entity>>(), types, tags);
    }

    public CantInteractTrait(@NotNull List<Class<? extends Entity>> classes) {
        this(false, classes, new ArrayList(), new ArrayList());
    }

    public CantInteractTrait(boolean canOnlyInteractWithListed, @NotNull List<Class<? extends Entity>> classes) {
        this(canOnlyInteractWithListed, classes, new ArrayList(), new ArrayList());
    }

    public CantInteractTrait(@NotNull List<Class<? extends Entity>> classes, @NotNull List<EntityType<?>> types, @NotNull List<TagKey<EntityType<?>>> tags) {
        this(false, classes, types, tags);
    }

    public CantInteractTrait(boolean canOnlyInteractWithListed, @NotNull List<Class<? extends Entity>> classes, @NotNull List<EntityType<?>> types, @NotNull List<TagKey<EntityType<?>>> tags) {
        this.canOnlyInteractWithListed = canOnlyInteractWithListed;
        this.classes = classes;
        this.types = types;
        this.tags = tags;
    }

    public boolean canInteractWithEntity(Entity entity) {
        boolean bool = false;
        for (Class<? extends Entity> clazz : this.classes) {
            if (!clazz.isInstance(entity)) continue;
            bool = true;
            break;
        }
        if (this.types.contains(entity.m_6095_())) {
            bool = true;
        }
        for (TagKey tagKey : this.tags) {
            if (!entity.m_6095_().m_204039_(tagKey)) continue;
            bool = true;
            break;
        }
        return bool == this.canOnlyInteractWithListed;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends ShapeTrait<?>> codec() {
        return CODEC;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public TextureAtlasSprite getIcon() {
        BakedModel itemModel = Minecraft.m_91087_().m_91291_().m_115103_().m_109394_(Items.f_42383_);
        if (itemModel != null) {
            return itemModel.m_6160_();
        }
        return super.getIcon();
    }
}

