/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.data.traits;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import tocraft.craftedcore.data.SynchronizedJsonReloadListener;
import tocraft.craftedcore.platform.PlatformData;
import tocraft.walkers.Walkers;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;

public class TraitDataManager
extends SynchronizedJsonReloadListener {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).create();
    public static Codec<TraitList> TRAIT_LIST_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("required_mod", (Object)"").forGetter(TraitList::requiredMod), (App)Codec.list((Codec)class_2960.field_25139).optionalFieldOf("entity_types", new ArrayList()).forGetter(TraitList::entityTypeKeys), (App)Codec.list((Codec)class_2960.field_25139).optionalFieldOf("entity_tags", new ArrayList()).forGetter(TraitList::entityTagKeys), (App)Codec.list(TraitRegistry.getTraitCodec()).fieldOf("traits").forGetter(TraitList::traitList)).apply((Applicative)instance, instance.stable(TraitList::new)));

    public TraitDataManager() {
        super(GSON, "walkers/traits");
    }

    protected void onApply(Map<class_2960, JsonElement> map) {
        TraitRegistry.clearAll();
        TraitRegistry.registerDefault();
        for (Map.Entry<class_2960, JsonElement> mapEntry : map.entrySet()) {
            TraitList traitList = this.traitListFromJson(mapEntry.getValue().getAsJsonObject());
            if (traitList.isEmpty() || traitList.requiredMod() != null && !traitList.requiredMod().isBlank() && !PlatformData.isModLoaded((String)traitList.requiredMod())) continue;
            for (class_1299<class_1309> class_12992 : traitList.entityTypes()) {
                TraitRegistry.registerByType(class_12992, traitList.traitList().stream().map(trait -> trait).toList());
            }
            if (!traitList.entityTypes().isEmpty()) {
                TraitDataManager.logRegistration(traitList.entityTypes(), traitList.traitList());
            }
            for (class_6862 class_68622 : traitList.entityTags()) {
                TraitRegistry.registerByTag(class_68622, traitList.traitList().stream().map(trait -> trait).toList());
            }
            if (traitList.entityTags().isEmpty()) continue;
            TraitDataManager.logRegistration(traitList.entityTags(), traitList.traitList());
        }
    }

    private static void logRegistration(Object key, List<ShapeTrait<?>> traitList) {
        Walkers.LOGGER.info("{}: {} registered for {}", new Object[]{TraitDataManager.class.getSimpleName(), key, traitList.stream().map(trait -> trait.getClass().getSimpleName()).toArray(String[]::new)});
    }

    protected TraitList traitListFromJson(JsonObject json) {
        return (TraitList)TRAIT_LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(msg -> {
            throw new JsonParseException(msg);
        });
    }

    public record TraitList(String requiredMod, List<class_2960> entityTypeKeys, List<class_2960> entityTagKeys, List<ShapeTrait<?>> traitList) {
        public TraitList(List<class_1299<?>> entityTypeKeys, List<class_6862<class_1299<?>>> entityTagKeys, List<ShapeTrait<?>> traitList, String requiredMod) {
            this(requiredMod, entityTypeKeys.stream().map(class_1299::method_5890).toList(), entityTagKeys.stream().map(class_6862::comp_327).toList(), traitList);
        }

        public List<class_1299<class_1309>> entityTypes() {
            return this.entityTypeKeys.stream().filter(arg_0 -> Walkers.getEntityTypeRegistry().method_10250(arg_0)).map(type -> (class_1299)Walkers.getEntityTypeRegistry().method_10223(type)).toList();
        }

        public List<class_6862<class_1299<?>>> entityTags() {
            return this.entityTagKeys().stream().map(tag -> class_6862.method_40092((class_5321)Walkers.getEntityTypeRegistry().method_30517(), (class_2960)tag)).toList();
        }

        public boolean isEmpty() {
            return this.entityTypeKeys().isEmpty() && this.entityTagKeys().isEmpty() || this.traitList().isEmpty();
        }
    }
}

