/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.impl.tick;

import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import tocraft.craftedcore.event.client.ClientTickEvents;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.Walkers;
import tocraft.walkers.WalkersClient;
import tocraft.walkers.ability.AbilityRegistry;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.blacklist.EntityBlacklist;
import tocraft.walkers.api.platform.ApiLevel;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.ClientNetworking;
import tocraft.walkers.network.impl.SwapPackets;
import tocraft.walkers.network.impl.SwapVariantPackets;
import tocraft.walkers.network.impl.UnlockPackets;

@OnlyIn(value=Dist.CLIENT)
public class KeyPressHandler
implements ClientTickEvents.Client {
    private float currentTimer = 0.0f;

    public void tick(Minecraft client) {
        if (client.player != null) {
            if (WalkersClient.ABILITY_KEY.consumeClick()) {
                this.handleAbilityKey(client);
            }
            if (WalkersClient.TRANSFORM_KEY.consumeClick()) {
                if (ApiLevel.getCurrentLevel().canMorph) {
                    SwapPackets.sendSwapRequest();
                } else {
                    client.player.displayClientMessage((Component)TComponent.translatable((String)"walkers.feature_not_available", (Object[])new Object[0]), true);
                }
            }
            if (WalkersClient.VARIANTS_MENU_KEY.consumeClick() && Walkers.CONFIG.unlockEveryVariant) {
                if (ApiLevel.getCurrentLevel().allowVariantsMenu) {
                    LivingEntity shape = PlayerShape.getCurrentShape((Player)client.player);
                    if (shape != null) {
                        ShapeType<LivingEntity> shapeType = ShapeType.from(shape);
                        if (WalkersClient.isRenderingVariantsMenu) {
                            SwapVariantPackets.sendSwapRequest(shapeType.getVariantData() + WalkersClient.variantOffset);
                        }
                        WalkersClient.variantOffset = 0;
                        WalkersClient.isRenderingVariantsMenu = !WalkersClient.isRenderingVariantsMenu;
                    }
                } else {
                    client.player.displayClientMessage((Component)TComponent.translatable((String)"walkers.feature_not_available", (Object[])new Object[0]), true);
                }
            }
            if (WalkersClient.isRenderingVariantsMenu && (client.options.hideGui || !Walkers.CONFIG.unlockEveryVariant || client.screen != null || PlayerShape.getCurrentShape((Player)client.player) == null)) {
                WalkersClient.isRenderingVariantsMenu = false;
            }
            if (WalkersClient.UNLOCK_KEY.isDown()) {
                if (ApiLevel.getCurrentLevel().canUnlock) {
                    this.handleUnlockKey(client);
                } else {
                    client.player.displayClientMessage((Component)TComponent.translatable((String)"walkers.feature_not_available", (Object[])new Object[0]), true);
                }
            } else if (this.currentTimer != Walkers.CONFIG.unlockTimer) {
                this.currentTimer = Walkers.CONFIG.unlockTimer;
            }
        }
    }

    private void handleAbilityKey(Minecraft client) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)client.player);
        if (shape != null && AbilityRegistry.has(shape)) {
            ClientNetworking.sendAbilityRequest();
        }
    }

    private void handleUnlockKey(Minecraft client) {
        if (client.player != null && Walkers.isPlayerBlacklisted(client.player.getUUID()) && Walkers.CONFIG.blacklistPreventsUnlocking) {
            client.player.displayClientMessage((Component)TComponent.translatable((String)"walkers.player_blacklisted", (Object[])new Object[0]), true);
            return;
        }
        HitResult hit = client.hitResult;
        if (client.player != null && (((PlayerDataProvider)client.player).walkers$get2ndShape() == null || Walkers.CONFIG.unlockOverridesCurrentShape) && hit instanceof EntityHitResult) {
            LivingEntity living;
            ShapeType<LivingEntity> type;
            Entity entityHit = ((EntityHitResult)hit).getEntity();
            if (entityHit instanceof LivingEntity && (type = ShapeType.from(living = (LivingEntity)entityHit)) != null) {
                if (EntityBlacklist.isBlacklisted(type.getEntityType())) {
                    client.player.displayClientMessage((Component)TComponent.translatable((String)"walkers.unlock_entity_blacklisted", (Object[])new Object[0]), true);
                } else if (this.currentTimer <= 0.0f) {
                    UnlockPackets.sendUnlockRequest(type);
                    MutableComponent name = TComponent.translatable((String)type.getEntityType().getDescriptionId(), (Object[])new Object[0]);
                    client.player.displayClientMessage((Component)TComponent.translatable((String)"walkers.unlock_entity", (Object[])new Object[]{name}), true);
                    this.currentTimer = Walkers.CONFIG.unlockTimer;
                } else {
                    client.player.displayClientMessage((Component)TComponent.translatable((String)"walkers.unlock_progress", (Object[])new Object[0]), true);
                    this.currentTimer -= 1.0f;
                }
            }
        } else {
            this.currentTimer = Walkers.CONFIG.unlockTimer;
        }
    }
}

