/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin;

import com.google.common.base.Suppliers;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import tocraft.walkers.api.PlayerShape;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityFoodMixin
extends Entity {
    @Unique
    private static final Supplier<List<FoodProperties>> WOLVES_IGNORE = Suppliers.memoize(() -> Arrays.asList(Foods.CHICKEN, Foods.PUFFERFISH, Foods.ROTTEN_FLESH));

    public LivingEntityFoodMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"addEatEffect(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void removeFleshHungerForWolves(ItemStack food, Level level, LivingEntity livingEntity, CallbackInfo ci) {
        Player player;
        LivingEntity shape;
        LivingEntity livingEntity2 = (LivingEntity)this;
        if (livingEntity2 instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)livingEntity2)) instanceof Wolf && WOLVES_IGNORE.get().contains(food.getItem().getFoodProperties())) {
            ci.cancel();
        }
    }
}

