/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.impl.NearbySongAccessor;
import tocraft.walkers.impl.ShapeDataProvider;
import tocraft.walkers.mixin.accessor.LivingEntityAccessor;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.AquaticTrait;
import tocraft.walkers.traits.impl.AttackForHealthTrait;
import tocraft.walkers.traits.impl.CantFreezeTrait;
import tocraft.walkers.traits.impl.ClimbBlocksTrait;
import tocraft.walkers.traits.impl.FlyingTrait;
import tocraft.walkers.traits.impl.HumanoidTrait;
import tocraft.walkers.traits.impl.ImmunityTrait;
import tocraft.walkers.traits.impl.MobEffectTrait;
import tocraft.walkers.traits.impl.SlowFallingTrait;
import tocraft.walkers.traits.impl.StandOnFluidTrait;
import tocraft.walkers.traits.impl.TemperatureTrait;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements NearbySongAccessor {
    @Unique
    private boolean walkers$nearbySongPlaying = false;

    @Shadow
    public abstract void kill();

    @Shadow
    public abstract boolean hurt(DamageSource var1, float var2);

    protected LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @WrapOperation(method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/world/effect/MobEffect;)Z", ordinal=0)})
    private boolean slowFall(LivingEntity instance, MobEffect effect, Operation<Boolean> original) {
        Player player;
        LivingEntity shape;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)livingEntityMixin)) != null) {
            boolean bool = false;
            for (FlyingTrait flyingTrait : TraitRegistry.get(shape, FlyingTrait.ID).stream().map(trait -> (FlyingTrait)trait).toList()) {
                if (!flyingTrait.slowFalling) continue;
                bool = true;
                break;
            }
            if (!this.isShiftKeyDown() && (bool || TraitRegistry.has(shape, SlowFallingTrait.ID))) {
                return true;
            }
        }
        return (Boolean)original.call(new Object[]{instance, effect});
    }

    @ModifyVariable(method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/world/effect/MobEffect;)Z", ordinal=1), ordinal=0)
    public float applyWaterCreatureSwimSpeedBoost(float j) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player) {
            Player player = (Player)livingEntityMixin;
            LivingEntity shape = PlayerShape.getCurrentShape(player);
            for (ShapeTrait<LivingEntity> trait : TraitRegistry.get(shape, AquaticTrait.ID)) {
                if (!((AquaticTrait)trait).isAquatic) continue;
                return 0.96f;
            }
        }
        return j;
    }

    @Inject(method={"causeFallDamage(FFLnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity shape;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)livingEntityMixin)) != null) {
            boolean takesFallDamage = shape.causeFallDamage(fallDistance, damageMultiplier, damageSource);
            int damageAmount = ((LivingEntityAccessor)shape).callCalculateFallDamage(fallDistance, damageMultiplier);
            if (takesFallDamage && damageAmount > 0) {
                LivingEntity.Fallsounds fallSounds = shape.getFallSounds();
                this.playSound(damageAmount > 4 ? fallSounds.big() : fallSounds.small(), 1.0f, 1.0f);
                ((LivingEntityAccessor)shape).callPlayBlockFallSound();
                this.hurt(this.damageSources().fall(), damageAmount);
                cir.setReturnValue((Object)true);
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"hasEffect(Lnet/minecraft/world/effect/MobEffect;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void returnHasNightVision(MobEffect effect, CallbackInfoReturnable<Boolean> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player) {
            Player player = (Player)livingEntityMixin;
            LivingEntity shape = PlayerShape.getCurrentShape(player);
            if (TraitRegistry.has(shape, MobEffectTrait.ID)) {
                List<MobEffectTrait> traitList = TraitRegistry.get(shape, MobEffectTrait.ID).stream().map(trait -> (MobEffectTrait)trait).toList();
                for (MobEffectTrait mobEffectTrait : traitList) {
                    if (mobEffectTrait.showInInventory || !mobEffectTrait.applyToSelf || !effect.equals(mobEffectTrait.mobEffectInstance.getEffect())) continue;
                    cir.setReturnValue((Object)true);
                    return;
                }
            }
            for (ShapeTrait<LivingEntity> immunityTrait : TraitRegistry.get(shape, ImmunityTrait.ID)) {
                if (!((ImmunityTrait)immunityTrait).effect.equals(effect)) continue;
                cir.setReturnValue((Object)false);
                return;
            }
        }
    }

    @Inject(method={"getEffect(Lnet/minecraft/world/effect/MobEffect;)Lnet/minecraft/world/effect/MobEffectInstance;"}, at={@At(value="HEAD")}, cancellable=true)
    private void returnNightVisionInstance(MobEffect effect, CallbackInfoReturnable<MobEffectInstance> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player) {
            Player player = (Player)livingEntityMixin;
            LivingEntity shape = PlayerShape.getCurrentShape(player);
            if (TraitRegistry.has(shape, MobEffectTrait.ID)) {
                List<MobEffectTrait> traitList = TraitRegistry.get(shape, MobEffectTrait.ID).stream().map(trait -> (MobEffectTrait)trait).toList();
                for (MobEffectTrait mobEffectTrait : traitList) {
                    MobEffectInstance mobEffectInstance;
                    if (mobEffectTrait.showInInventory || !mobEffectTrait.applyToSelf || !effect.equals((mobEffectInstance = mobEffectTrait.mobEffectInstance).getEffect())) continue;
                    cir.setReturnValue((Object)new MobEffectInstance(mobEffectInstance.getEffect(), mobEffectInstance.getDuration(), mobEffectInstance.getAmplifier(), mobEffectInstance.isAmbient(), mobEffectInstance.isVisible(), mobEffectInstance.showIcon()));
                    return;
                }
            }
            for (ShapeTrait<LivingEntity> immunityTrait : TraitRegistry.get(shape, ImmunityTrait.ID)) {
                if (!((ImmunityTrait)immunityTrait).effect.equals(effect)) continue;
                cir.setReturnValue(null);
                return;
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getEyeHeight(Lnet/minecraft/world/entity/Pose;Lnet/minecraft/world/entity/EntityDimensions;)F"}, cancellable=true)
    public void getEyeHeight(Pose pose, EntityDimensions dimensions, CallbackInfoReturnable<Float> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            try {
                LivingEntity shape = PlayerShape.getCurrentShape(player);
                if (shape != null) {
                    float shapeEyeHeight = shape.getEyeHeight(pose);
                    if (pose == Pose.CROUCHING && TraitRegistry.has(shape, HumanoidTrait.ID)) {
                        cir.setReturnValue((Object)Float.valueOf(shapeEyeHeight * 1.27f / 1.62f));
                        return;
                    }
                    cir.setReturnValue((Object)Float.valueOf(shapeEyeHeight));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Inject(method={"isSensitiveToWater()Z"}, at={@At(value="HEAD")}, cancellable=true)
    protected void shape_isSensitiveToWater(CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity entity;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player && (entity = PlayerShape.getCurrentShape(player = (Player)livingEntity)) != null) {
            cir.setReturnValue((Object)entity.isSensitiveToWater());
        }
    }

    @Inject(method={"setRecordPlayingNearby(Lnet/minecraft/core/BlockPos;Z)V"}, at={@At(value="RETURN")})
    @OnlyIn(value=Dist.CLIENT)
    protected void shape_setRecordPlayingNearby(BlockPos songPosition, boolean playing, CallbackInfo ci) {
        if ((LivingEntity)this instanceof Player) {
            this.walkers$nearbySongPlaying = playing;
        }
    }

    @Override
    public boolean shape_isNearbySongPlaying() {
        return this.walkers$nearbySongPlaying;
    }

    @Inject(method={"isInvertedHealAndHarm()Z"}, at={@At(value="HEAD")}, cancellable=true)
    protected void shape_isInvertedHealAndHarm(CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity shape;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)livingEntity)) != null) {
            cir.setReturnValue((Object)shape.isInvertedHealAndHarm());
        }
    }

    @Inject(method={"canStandOnFluid(Lnet/minecraft/world/level/material/FluidState;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    protected void shape_canStandOnFluid(FluidState state, CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity shape;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)livingEntity)) != null) {
            if (shape.canStandOnFluid(state)) {
                cir.setReturnValue((Object)true);
            } else {
                for (StandOnFluidTrait standOnFluidTrait : TraitRegistry.get(shape, StandOnFluidTrait.ID).stream().map(entry -> (StandOnFluidTrait)entry).toList()) {
                    if (!state.is(standOnFluidTrait.fluidTagKey)) continue;
                    cir.setReturnValue((Object)true);
                    return;
                }
            }
        }
    }

    @Inject(method={"onClimbable()Z"}, at={@At(value="HEAD")}, cancellable=true)
    protected void shape_allowSpiderClimbing(CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity shape;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)livingEntity)) != null) {
            BlockState blockState = CEntity.level((Entity)this).getBlockState(this.blockPosition());
            for (ClimbBlocksTrait climbBlocksTrait : TraitRegistry.get(shape, ClimbBlocksTrait.ID).stream().map(entry -> (ClimbBlocksTrait)entry).toList()) {
                for (Block invalidBlock : climbBlocksTrait.invalidBlocks) {
                    if (!blockState.is(invalidBlock)) continue;
                    return;
                }
                if (climbBlocksTrait.validBlocks.isEmpty()) {
                    cir.setReturnValue((Object)this.horizontalCollision);
                    continue;
                }
                for (Block validBlock : climbBlocksTrait.validBlocks) {
                    if (!blockState.is(validBlock)) continue;
                    cir.setReturnValue((Object)(!climbBlocksTrait.horizontalCollision || this.horizontalCollision ? 1 : 0));
                    return;
                }
            }
        }
    }

    @Inject(method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;addEatEffect(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)V")})
    private void regenerateWoolFromFood(Level level, ItemStack food, CallbackInfoReturnable<ItemStack> cir) {
        Sheep sheepShape;
        Player player;
        LivingEntity shape;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)livingEntityMixin)) instanceof Sheep && (sheepShape = (Sheep)shape).isSheared()) {
            sheepShape.setSheared(false);
        }
    }

    @Inject(method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")})
    private void dieFromCookies(Level level, ItemStack food, CallbackInfoReturnable<ItemStack> cir) {
        Player player;
        LivingEntity shape;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)livingEntityMixin)) instanceof Parrot && food.is(Items.COOKIE)) {
            player.addEffect(new MobEffectInstance(MobEffects.POISON, 900));
            if (player.isCreative() || !this.isInvulnerable()) {
                this.hurt(this.damageSources().playerAttack(player), Float.MAX_VALUE);
            }
        }
    }

    @Inject(method={"isSensitiveToWater()Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void handleWaterSensitivity(CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity shape;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)livingEntityMixin)) != null) {
            cir.setReturnValue((Object)shape.isSensitiveToWater());
        }
    }

    @Inject(method={"canFreeze()Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void temperatureTraitPreventFreeze(@NotNull CallbackInfoReturnable<Boolean> cir) {
        LivingEntity shape;
        if (((Boolean)cir.getReturnValue()).booleanValue() && this instanceof Player && (shape = PlayerShape.getCurrentShape((Player)this)) != null) {
            if (TraitRegistry.has(shape, CantFreezeTrait.ID)) {
                cir.setReturnValue((Object)false);
            } else {
                for (ShapeTrait<LivingEntity> temperatureTrait : TraitRegistry.get(shape, TemperatureTrait.ID)) {
                    if (!((TemperatureTrait)temperatureTrait).coldEnoughToSnow) continue;
                    cir.setReturnValue((Object)false);
                }
            }
        }
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void setPlayerSource(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Entity player;
        Mob mobEntity;
        int playerId;
        Entity attacker = source.getEntity();
        if (attacker instanceof Mob && (playerId = ((ShapeDataProvider)(mobEntity = (Mob)attacker)).walkers$shapedPlayer()) != -1 && (player = this.level().getEntity(playerId)) instanceof Player) {
            DamageSource damageSource = this.damageSources().playerAttack((Player)this);
            cir.setReturnValue((Object)this.hurt(damageSource, amount));
        }
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="RETURN")})
    private void attackForHealthTrait(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean didHurtTarget = (Boolean)cir.getReturnValue();
            LivingEntity shape = PlayerShape.getCurrentShape(player);
            if (didHurtTarget && TraitRegistry.has(shape, AttackForHealthTrait.ID)) {
                player.heal(Math.max(1.0f, amount / 2.0f));
            }
        }
    }
}

