/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin;

import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.FearedTrait;
import tocraft.walkers.traits.impl.PreyTrait;

@Mixin(value={Mob.class})
public class MobHunterPreyMixin {
    @Shadow
    @Final
    protected GoalSelector targetSelector;
    @Shadow
    @Final
    protected GoalSelector goalSelector;

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="TAIL")})
    protected void registerCustomGoals(CallbackInfo ci) {
        if (!Walkers.CONFIG.hunterAttackAsPreyMorphedPlayer) {
            return;
        }
        for (Map.Entry<ShapeTrait<?>, Predicate<LivingEntity>> trait : TraitRegistry.getAllRegisteredById(PreyTrait.ID).entrySet()) {
            PreyTrait preyTrait = (PreyTrait)trait.getKey();
            if (!preyTrait.isHunter((LivingEntity)((Mob)this))) continue;
            this.targetSelector.addGoal(preyTrait.getPriority(), (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, preyTrait.getRandInt(), false, false, player -> {
                LivingEntity shape = PlayerShape.getCurrentShape((Player)player);
                return shape != null && ((Predicate)trait.getValue()).test(shape);
            }));
        }
        MobHunterPreyMixin mobHunterPreyMixin = this;
        if (mobHunterPreyMixin instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)mobHunterPreyMixin;
            for (Map.Entry entry : TraitRegistry.getAllRegisteredById(FearedTrait.ID).entrySet()) {
                FearedTrait fearedTrait = (FearedTrait)entry.getKey();
                if (!fearedTrait.isFeared((LivingEntity)mob)) continue;
                this.goalSelector.addGoal(fearedTrait.getPriority(), (Goal)new AvoidEntityGoal(mob, Player.class, player -> {
                    LivingEntity shape = PlayerShape.getCurrentShape((Player)player);
                    return shape != null && ((Predicate)trait.getValue()).test(shape);
                }, 6.0f, 1.0, 1.2, player -> true));
            }
        }
    }
}

