/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin.client;

import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.util.Maths;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.model.ArmRenderingManipulator;
import tocraft.walkers.api.model.EntityArms;
import tocraft.walkers.api.model.EntityUpdater;
import tocraft.walkers.api.model.EntityUpdaters;
import tocraft.walkers.mixin.accessor.EntityAccessor;
import tocraft.walkers.mixin.accessor.LivingEntityAccessor;
import tocraft.walkers.mixin.client.accessor.LimbAnimatorAccessor;
import tocraft.walkers.mixin.client.accessor.LivingEntityRendererAccessor;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={PlayerRenderer.class})
public abstract class PlayerEntityRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    @Shadow
    @Contract(pure=true)
    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable HumanoidModel.ArmPose getArmPose(AbstractClientPlayer player, InteractionHand hand) {
        return null;
    }

    private PlayerEntityRendererMixin(EntityRendererProvider.Context ctx, PlayerModel<AbstractClientPlayer> model, float shadowRadius) {
        super(ctx, model, shadowRadius);
    }

    @WrapWithCondition(method={"render(Lnet/minecraft/client/player/AbstractClientPlayer;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V")})
    private boolean redirectRender(LivingEntityRenderer<AbstractClientPlayer, EntityModel<AbstractClientPlayer>> renderer, LivingEntity player, float f, float g, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)player);
        if (shape != null) {
            if (Minecraft.getInstance().options.getCameraType().isFirstPerson() && player.getVehicle() == Minecraft.getInstance().cameraEntity) {
                return false;
            }
            ((LimbAnimatorAccessor)shape.walkAnimation).setPrevSpeed(((LimbAnimatorAccessor)player.walkAnimation).getPrevSpeed());
            shape.walkAnimation.setSpeed(player.walkAnimation.speed());
            ((LimbAnimatorAccessor)shape.walkAnimation).setPos(player.walkAnimation.position());
            shape.swinging = player.swinging;
            shape.swingTime = player.swingTime;
            shape.oAttackAnim = player.oAttackAnim;
            shape.attackAnim = player.attackAnim;
            shape.yBodyRot = player.yBodyRot;
            shape.yBodyRotO = player.yBodyRotO;
            shape.yHeadRot = player.yHeadRot;
            shape.yHeadRotO = player.yHeadRotO;
            shape.tickCount = player.tickCount;
            shape.swingingArm = player.swingingArm;
            ((LivingEntityAccessor)shape).setSwimAmount(((LivingEntityAccessor)player).getSwimAmount());
            ((LivingEntityAccessor)shape).setSwimAmountO(((LivingEntityAccessor)player).getSwimAmountO());
            shape.setOnGround(CEntity.isOnGround((Entity)player));
            shape.setDeltaMovement(player.getDeltaMovement());
            shape.setInvisible(player.isInvisibleTo((Player)Minecraft.getInstance().player));
            ((EntityAccessor)shape).setVehicle(player.getVehicle());
            ((EntityAccessor)shape).setPassengers((ImmutableList<Entity>)ImmutableList.copyOf((Collection)player.getPassengers()));
            ((EntityAccessor)shape).setTouchingWater(player.isInWater());
            if (shape instanceof Phantom) {
                shape.setXRot(-player.getXRot());
                shape.xRotO = -player.xRotO;
            } else {
                shape.setXRot(player.getXRot());
                shape.xRotO = player.xRotO;
            }
            if (Walkers.CONFIG.shapesEquipItems) {
                shape.setItemSlot(EquipmentSlot.MAINHAND, player.getItemBySlot(EquipmentSlot.MAINHAND));
                shape.setItemSlot(EquipmentSlot.OFFHAND, player.getItemBySlot(EquipmentSlot.OFFHAND));
            }
            if (Walkers.CONFIG.shapesEquipArmor) {
                shape.setItemSlot(EquipmentSlot.HEAD, player.getItemBySlot(EquipmentSlot.HEAD));
                shape.setItemSlot(EquipmentSlot.CHEST, player.getItemBySlot(EquipmentSlot.CHEST));
                shape.setItemSlot(EquipmentSlot.LEGS, player.getItemBySlot(EquipmentSlot.LEGS));
                shape.setItemSlot(EquipmentSlot.FEET, player.getItemBySlot(EquipmentSlot.FEET));
            }
            if (shape instanceof Mob) {
                ((Mob)shape).setAggressive(player.isUsingItem());
            }
            shape.setPose(player.getPose());
            shape.startUsingItem(player.getUsedItemHand() == null ? InteractionHand.MAIN_HAND : player.getUsedItemHand());
            ((LivingEntityAccessor)shape).callSetLivingEntityFlag(1, player.isUsingItem());
            shape.getTicksUsingItem();
            ((LivingEntityAccessor)shape).callUpdatingUsingItem();
            shape.hurtTime = player.hurtTime;
            EntityUpdater entityUpdater = EntityUpdaters.getUpdater(shape.getType());
            if (entityUpdater != null) {
                entityUpdater.update((Player)player, shape);
            }
            if (!player.isInvisibleTo((Player)Minecraft.getInstance().player) && !player.isSpectator()) {
                EntityRenderer shapeRenderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)shape);
                if (shapeRenderer instanceof HumanoidMobRenderer) {
                    this.shape_setBipedShapeModelPose((AbstractClientPlayer)player, shape, (LivingEntityRenderer<?, ?>)((HumanoidMobRenderer)shapeRenderer));
                }
                shapeRenderer.render((Entity)shape, f, g, matrixStack, buffer, packedLight);
                if (player != Minecraft.getInstance().player && PlayerEntityRendererMixin.walkers$showName(player)) {
                    this.renderNameTag((Entity)((AbstractClientPlayer)player), player.getDisplayName(), matrixStack, buffer, packedLight);
                }
            }
            return false;
        }
        return true;
    }

    @Unique
    private static boolean walkers$showName(@NotNull LivingEntity player) {
        Team team = player.getTeam();
        boolean showName = Walkers.CONFIG.showPlayerNametag;
        if (showName && team != null) {
            Team.Visibility visibility = team.getNameTagVisibility();
            Team localTeam = Minecraft.getInstance().player.getTeam();
            boolean sameTeam = Objects.equals(localTeam != null ? localTeam.getName() : null, team.getName());
            if (visibility == Team.Visibility.NEVER || sameTeam && visibility == Team.Visibility.HIDE_FOR_OWN_TEAM || !sameTeam && visibility == Team.Visibility.HIDE_FOR_OTHER_TEAMS) {
                showName = false;
            }
        }
        return showName;
    }

    @Unique
    private void shape_setBipedShapeModelPose(AbstractClientPlayer player, LivingEntity shape, LivingEntityRenderer<?, ?> shapeRenderer) {
        HumanoidModel shapeBipedModel = (HumanoidModel)shapeRenderer.getModel();
        if (shape.isSpectator()) {
            shapeBipedModel.setAllVisible(false);
            shapeBipedModel.head.visible = true;
            shapeBipedModel.hat.visible = true;
        } else {
            shapeBipedModel.setAllVisible(true);
            shapeBipedModel.hat.visible = player.isModelPartShown(PlayerModelPart.HAT);
            shapeBipedModel.crouching = shape.isCrouching();
            HumanoidModel.ArmPose mainHandPose = PlayerEntityRendererMixin.getArmPose(player, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose offHandPose = PlayerEntityRendererMixin.getArmPose(player, InteractionHand.OFF_HAND);
            if (mainHandPose != null && mainHandPose.isTwoHanded()) {
                HumanoidModel.ArmPose armPose = offHandPose = shape.getOffhandItem().isEmpty() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (mainHandPose != null && offHandPose != null && shape.getMainArm() == HumanoidArm.RIGHT) {
                shapeBipedModel.rightArmPose = mainHandPose;
                shapeBipedModel.leftArmPose = offHandPose;
            } else if (mainHandPose != null && offHandPose != null) {
                shapeBipedModel.rightArmPose = offHandPose;
                shapeBipedModel.leftArmPose = mainHandPose;
            }
        }
    }

    @Inject(method={"getRenderOffset(Lnet/minecraft/client/player/AbstractClientPlayer;F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyPositionOffset(AbstractClientPlayer player, float f, CallbackInfoReturnable<Vec3> cir) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)player);
        if (shape != null && shape instanceof TamableAnimal) {
            cir.setReturnValue((Object)super.getRenderOffset((Entity)player, f));
        }
    }

    @Inject(method={"renderHand(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/client/model/geom/ModelPart;Lnet/minecraft/client/model/geom/ModelPart;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderArm(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, ModelPart arm, ModelPart sleeve, CallbackInfo ci) {
        EntityRenderer renderer;
        LivingEntity shape = PlayerShape.getCurrentShape((Player)player);
        if (shape != null && (renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)shape)) instanceof LivingEntityRenderer) {
            LivingEntityRenderer rendererCasted = (LivingEntityRenderer)renderer;
            EntityModel model = ((LivingEntityRenderer)renderer).getModel();
            arm = null;
            sleeve = null;
            if (model instanceof HumanoidModel) {
                arm = player.getMainArm() == HumanoidArm.RIGHT ? ((HumanoidModel)model).rightArm : ((HumanoidModel)model).leftArm;
                if (model instanceof PlayerModel) {
                    sleeve = ((PlayerModel)model).rightSleeve;
                }
            } else {
                Tuple<ModelPart, ArmRenderingManipulator<?>> pair = EntityArms.get(shape, model);
                if (pair != null) {
                    arm = (ModelPart)pair.getA();
                    if (player.getMainArm() == HumanoidArm.LEFT) {
                        matrices.mulPose(Maths.getDegreesQuaternion((Vector3f)Maths.POSITIVE_Y(), (float)180.0f));
                    }
                    ((ArmRenderingManipulator)pair.getB()).run(matrices, model);
                    matrices.translate(0.0, -0.35, 0.5);
                }
            }
            model.attackTime = 0.0f;
            model.setupAnim((Entity)shape, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            if (arm != null) {
                arm.xRot = 0.0f;
                arm.render(matrices, vertexConsumers.getBuffer(((LivingEntityRendererAccessor)rendererCasted).callGetRenderType(shape, true, false, true)), light, OverlayTexture.NO_OVERLAY);
            }
            if (sleeve != null) {
                sleeve.xRot = 0.0f;
                sleeve.render(matrices, vertexConsumers.getBuffer(((LivingEntityRendererAccessor)rendererCasted).callGetRenderType(shape, true, false, true)), light, OverlayTexture.NO_OVERLAY);
            }
            ci.cancel();
        }
    }
}

