/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.network.impl;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.platform.ApiLevel;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.ClientNetworking;
import tocraft.walkers.network.NetworkHandler;

public class SwapPackets {
    public static void registerWalkersRequestPacketHandler() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (ResourceLocation)NetworkHandler.SHAPE_REQUEST, (context, packet) -> context.getPlayer().getServer().execute(() -> {
            if (Walkers.isPlayerBlacklisted(context.getPlayer().getUUID()) && Walkers.CONFIG.blacklistPreventsMorphing) {
                context.getPlayer().displayClientMessage((Component)TComponent.translatable((String)"walkers.player_blacklisted", (Object[])new Object[0]), true);
                return;
            }
            if (!ApiLevel.getCurrentLevel().canMorph) {
                return;
            }
            @Nullable ShapeType<?> type = null;
            if (PlayerShape.getCurrentShape(context.getPlayer()) == null) {
                type = ((PlayerDataProvider)context.getPlayer()).walkers$get2ndShape();
            }
            if (type != null) {
                PlayerShape.updateShapes((ServerPlayer)context.getPlayer(), type.create(CEntity.level((Entity)context.getPlayer()), context.getPlayer()));
            } else {
                PlayerShape.updateShapes((ServerPlayer)context.getPlayer(), null);
            }
            context.getPlayer().refreshDimensions();
        }));
    }

    public static void sendSwapRequest() {
        if (!ApiLevel.getCurrentLevel().canMorph) {
            return;
        }
        ModernNetworking.sendToServer((ResourceLocation)ClientNetworking.SHAPE_REQUEST, (CompoundTag)new CompoundTag());
    }
}

