/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.traits.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.patched.CRegistries;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.Walkers;
import tocraft.walkers.traits.ShapeTrait;

public class ClimbBlocksTrait<E extends LivingEntity>
extends ShapeTrait<E> {
    public static final ResourceLocation ID = Walkers.id("climb_blocks");
    public static final MapCodec<ClimbBlocksTrait<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("horizontal_collision", (Object)true).forGetter(o -> o.horizontalCollision), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("valid_blocks", new ArrayList()).forGetter(o -> o.validBlocks.stream().map(o1 -> CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"block")).getKey(o1)).toList()), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("invalid_blocks", new ArrayList()).forGetter(o -> o.invalidBlocks.stream().map(o1 -> CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"block")).getKey(o1)).toList())).apply((Applicative)instance, instance.stable((horizontalCollision, validBlocksLocation, invalidBlocksLocation) -> {
        ArrayList<Block> validBlocks = new ArrayList<Block>();
        for (ResourceLocation resourceLocation : validBlocksLocation) {
            if (!CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"block")).containsKey(resourceLocation)) continue;
            validBlocks.add((Block)CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"block")).get(resourceLocation));
        }
        ArrayList<Block> invalidBlocks = new ArrayList<Block>();
        for (ResourceLocation resourceLocation : invalidBlocksLocation) {
            if (!CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"block")).containsKey(resourceLocation)) continue;
            validBlocks.add((Block)CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"block")).get(resourceLocation));
        }
        return new ClimbBlocksTrait((boolean)horizontalCollision, (List<Block>)validBlocks, (List<Block>)invalidBlocks);
    })));
    public final boolean horizontalCollision;
    public final List<Block> validBlocks;
    public final List<Block> invalidBlocks;

    public ClimbBlocksTrait() {
        this(true);
    }

    public ClimbBlocksTrait(boolean horizontalCollision) {
        this(horizontalCollision, new ArrayList<Block>(), new ArrayList<Block>());
    }

    public ClimbBlocksTrait(List<Block> validBlocks, List<Block> invalidBlocks) {
        this(false, validBlocks, invalidBlocks);
    }

    public ClimbBlocksTrait(boolean horizontalCollision, List<Block> validBlocks, List<Block> invalidBlocks) {
        this.horizontalCollision = horizontalCollision;
        this.validBlocks = validBlocks;
        this.invalidBlocks = invalidBlocks;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends ShapeTrait<?>> codec() {
        return CODEC;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public TextureAtlasSprite getIcon() {
        return Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getBlockModel(Blocks.VINE.defaultBlockState()).getParticleIcon();
    }
}

