/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.ability;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.GenericShapeAbility;
import tocraft.walkers.ability.ShapeAbility;
import tocraft.walkers.ability.impl.generic.ClearEffectsAbility;
import tocraft.walkers.ability.impl.generic.ExplosionAbility;
import tocraft.walkers.ability.impl.generic.GetItemAbility;
import tocraft.walkers.ability.impl.generic.JumpAbility;
import tocraft.walkers.ability.impl.generic.RandomTeleportationAbility;
import tocraft.walkers.ability.impl.generic.SaturateAbility;
import tocraft.walkers.ability.impl.generic.ShootDragonFireball;
import tocraft.walkers.ability.impl.generic.ShootFireballAbility;
import tocraft.walkers.ability.impl.generic.ShootSnowballAbility;
import tocraft.walkers.ability.impl.generic.TeleportationAbility;
import tocraft.walkers.ability.impl.generic.ThrowPotionsAbility;
import tocraft.walkers.ability.impl.specific.AngerAbility;
import tocraft.walkers.ability.impl.specific.ChickenAbility;
import tocraft.walkers.ability.impl.specific.EvokerAbility;
import tocraft.walkers.ability.impl.specific.LlamaAbility;
import tocraft.walkers.ability.impl.specific.PufferfishAbility;
import tocraft.walkers.ability.impl.specific.RabbitAbility;
import tocraft.walkers.ability.impl.specific.RaidAbility;
import tocraft.walkers.ability.impl.specific.SheepAbility;
import tocraft.walkers.ability.impl.specific.ShulkerAbility;
import tocraft.walkers.ability.impl.specific.TurtleAbility;
import tocraft.walkers.ability.impl.specific.WitherAbility;
import tocraft.walkers.integrations.Integrations;

public class AbilityRegistry {
    private static final Map<Predicate<LivingEntity>, ShapeAbility<?>> specificAbilities = Collections.synchronizedMap(new LinkedHashMap());
    private static final Map<Predicate<LivingEntity>, GenericShapeAbility<?>> genericAbilities = Collections.synchronizedMap(new LinkedHashMap());
    private static final Map<ResourceLocation, MapCodec<? extends GenericShapeAbility<?>>> abilityCodecById = new HashMap();
    private static final Map<MapCodec<? extends GenericShapeAbility<?>>, ResourceLocation> abilityIdByCodec = new IdentityHashMap();

    @ApiStatus.Internal
    public static void initialize() {
        AbilityRegistry.registerCodec(ShootFireballAbility.ID, ShootFireballAbility.CODEC);
        AbilityRegistry.registerCodec(ClearEffectsAbility.ID, ClearEffectsAbility.CODEC);
        AbilityRegistry.registerCodec(ExplosionAbility.ID, ExplosionAbility.CODEC);
        AbilityRegistry.registerCodec(ShootDragonFireball.ID, ShootDragonFireball.CODEC);
        AbilityRegistry.registerCodec(TeleportationAbility.ID, TeleportationAbility.CODEC);
        AbilityRegistry.registerCodec(RandomTeleportationAbility.ID, RandomTeleportationAbility.CODEC);
        AbilityRegistry.registerCodec(JumpAbility.ID, JumpAbility.CODEC);
        AbilityRegistry.registerCodec(ThrowPotionsAbility.ID, ThrowPotionsAbility.CODEC);
        AbilityRegistry.registerCodec(SaturateAbility.ID, SaturateAbility.CODEC);
        AbilityRegistry.registerCodec(ShootSnowballAbility.ID, ShootSnowballAbility.CODEC);
        AbilityRegistry.registerCodec(GetItemAbility.ID, GetItemAbility.CODEC);
    }

    @ApiStatus.Internal
    public static void registerDefault() {
        AbilityRegistry.registerByPredicate(livingEntity -> livingEntity instanceof NeutralMob, new AngerAbility());
        AbilityRegistry.registerByTag(EntityTypeTags.f_13121_, new RaidAbility<LivingEntity>());
        AbilityRegistry.registerByClass(AbstractHorse.class, new JumpAbility());
        AbilityRegistry.registerByClass(Blaze.class, new ShootFireballAbility(Items.f_42593_, false));
        AbilityRegistry.registerByPredicate(entity -> entity instanceof Creeper && !((Creeper)entity).m_7090_(), new ExplosionAbility());
        AbilityRegistry.registerByPredicate(entity -> entity instanceof Creeper && ((Creeper)entity).m_7090_(), new ExplosionAbility(6.0f));
        AbilityRegistry.registerByClass(EnderDragon.class, new ShootDragonFireball());
        AbilityRegistry.registerByClass(EnderMan.class, new TeleportationAbility());
        AbilityRegistry.registerByClass(Ghast.class, new ShootFireballAbility(Items.f_42613_, true));
        AbilityRegistry.registerByClass(SnowGolem.class, new ShootSnowballAbility());
        AbilityRegistry.registerByClass(WitherBoss.class, new WitherAbility());
        AbilityRegistry.registerByClass(Cow.class, new ClearEffectsAbility());
        AbilityRegistry.registerByClass(Goat.class, new ClearEffectsAbility());
        AbilityRegistry.registerByClass(Endermite.class, new RandomTeleportationAbility());
        AbilityRegistry.registerByClass(Llama.class, new LlamaAbility());
        AbilityRegistry.registerByClass(Witch.class, new ThrowPotionsAbility());
        AbilityRegistry.registerByClass(Evoker.class, new EvokerAbility());
        AbilityRegistry.registerByClass(Wolf.class, new AngerAbility(SoundEvents.f_12622_, SoundEvents.f_12619_));
        AbilityRegistry.registerByClass(Sheep.class, new SheepAbility());
        AbilityRegistry.registerByClass(Chicken.class, new ChickenAbility());
        AbilityRegistry.registerByClass(MushroomCow.class, new SaturateAbility());
        AbilityRegistry.registerByClass(Bee.class, new AngerAbility(SoundEvents.f_11691_, SoundEvents.f_11690_));
        AbilityRegistry.registerByClass(Shulker.class, new ShulkerAbility());
        AbilityRegistry.registerByClass(Pufferfish.class, new PufferfishAbility());
        AbilityRegistry.registerByClass(Turtle.class, new TurtleAbility());
        AbilityRegistry.registerByClass(Rabbit.class, new RabbitAbility());
        AbilityRegistry.registerByClass(Skeleton.class, new GetItemAbility(new ItemStack((ItemLike)Items.f_42412_, 4)));
        ItemStack slownessArrows = new ItemStack((ItemLike)Items.f_42738_, 4);
        ItemStack poisonedArrows = new ItemStack((ItemLike)Items.f_42738_, 4);
        PotionUtils.m_43549_((ItemStack)slownessArrows, (Potion)Potions.f_43615_);
        PotionUtils.m_43549_((ItemStack)poisonedArrows, (Potion)Potions.f_43584_);
        AbilityRegistry.registerByClass(Stray.class, new GetItemAbility(slownessArrows));
        Integrations.registerAbilities();
        for (GenericShapeAbility<?> ability : genericAbilities.values()) {
            if (!abilityCodecById.containsKey(ability.getId())) {
                Walkers.LOGGER.warn("{} isn't registered!", (Object)ability.getId());
            }
            if (ability.getId() != null && ability.codec() != null) continue;
            Walkers.LOGGER.warn("{} isn't correctly setup!", (Object)ability.getClass().getSimpleName());
        }
    }

    public static <L extends LivingEntity> ShapeAbility<L> get(L shape) {
        if (Walkers.CONFIG.abilityBlacklist.contains(EntityType.m_20613_((EntityType)shape.m_6095_()).toString())) {
            return null;
        }
        ShapeAbility<?> ability = null;
        for (Map.Entry<Predicate<LivingEntity>, ShapeAbility<?>> entry : specificAbilities.entrySet()) {
            if (!entry.getKey().test(shape)) continue;
            ability = entry.getValue();
        }
        for (Map.Entry<Predicate<LivingEntity>, ShapeAbility<?>> entry : genericAbilities.entrySet()) {
            if (!entry.getKey().test(shape)) continue;
            ability = entry.getValue();
        }
        return ability;
    }

    public static <A extends LivingEntity> void registerByType(EntityType<A> type, ShapeAbility<A> ability) {
        AbilityRegistry.registerByPredicate(livingEntity -> type.equals(livingEntity.m_6095_()), ability);
    }

    public static void registerByTag(TagKey<EntityType<?>> entityTag, ShapeAbility<LivingEntity> ability) {
        AbilityRegistry.registerByPredicate(livingEntity -> livingEntity.m_6095_().m_204039_(entityTag), ability);
    }

    public static <A extends LivingEntity> void registerByClass(Class<A> entityClass, ShapeAbility<A> ability) {
        AbilityRegistry.registerByPredicate(entityClass::isInstance, ability);
    }

    public static void registerByPredicate(Predicate<LivingEntity> entityPredicate, ShapeAbility<?> ability) {
        if (ability instanceof GenericShapeAbility) {
            GenericShapeAbility genericShapeAbility = (GenericShapeAbility)ability;
            genericAbilities.put(entityPredicate, genericShapeAbility);
        } else {
            specificAbilities.put(entityPredicate, ability);
        }
    }

    public static <L extends LivingEntity> boolean has(L shape) {
        if (Walkers.CONFIG.abilityBlacklist.contains(EntityType.m_20613_((EntityType)shape.m_6095_()).toString())) {
            return false;
        }
        return specificAbilities.keySet().stream().anyMatch(predicate -> predicate.test(shape)) || genericAbilities.keySet().stream().anyMatch(predicate -> predicate.test(shape));
    }

    @ApiStatus.Internal
    public static void clearAll() {
        specificAbilities.clear();
        genericAbilities.clear();
    }

    public static void registerCodec(ResourceLocation abilityId, MapCodec<? extends GenericShapeAbility<?>> abilityCodec) {
        abilityCodecById.put(abilityId, abilityCodec);
        abilityIdByCodec.put(abilityCodec, abilityId);
    }

    @ApiStatus.Internal
    @Nullable
    public static MapCodec<? extends GenericShapeAbility<?>> getAbilityCodec(ResourceLocation abilityId) {
        return abilityCodecById.get(abilityId);
    }

    @ApiStatus.Internal
    @Nullable
    public static ResourceLocation getAbilityId(MapCodec<? extends GenericShapeAbility<?>> traitCodec) {
        return abilityIdByCodec.get(traitCodec);
    }

    @ApiStatus.Internal
    public static Codec<GenericShapeAbility<?>> getAbilityCodec() {
        Codec codec = ResourceLocation.f_135803_.flatXmap(resourceLocation -> Optional.ofNullable(AbilityRegistry.getAbilityCodec(resourceLocation)).map(DataResult::success).orElseGet(() -> Walkers.dataError("Unknown shape ability: " + String.valueOf(resourceLocation))), abilityCodec -> Optional.ofNullable(AbilityRegistry.getAbilityId(abilityCodec)).map(DataResult::success).orElseGet(() -> Walkers.dataError("Unknown shape ability codec: " + String.valueOf(abilityCodec))));
        return codec.dispatchStable(GenericShapeAbility::codec, MapCodec::codec);
    }
}

