/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.model;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.api.model.EntityUpdater;
import tocraft.walkers.api.model.impl.AbstractHorseEntityUpdater;
import tocraft.walkers.api.model.impl.ShulkerEntityUpdater;
import tocraft.walkers.api.model.impl.SquidEntityUpdater;
import tocraft.walkers.impl.NearbySongAccessor;
import tocraft.walkers.mixin.accessor.CreeperEntityAccessor;
import tocraft.walkers.mixin.accessor.ParrotEntityAccessor;

@OnlyIn(value=Dist.CLIENT)
public class EntityUpdaters {
    private static final Map<EntityType<? extends LivingEntity>, EntityUpdater<? extends LivingEntity>> map = new LinkedHashMap<EntityType<? extends LivingEntity>, EntityUpdater<? extends LivingEntity>>();

    public static <T extends LivingEntity> EntityUpdater<T> getUpdater(EntityType<T> entityType) {
        return map.getOrDefault(entityType, null);
    }

    public static <T extends LivingEntity> void register(EntityType<T> type, EntityUpdater<T> entityUpdater) {
        map.put(type, entityUpdater);
    }

    public static void init() {
        EntityUpdaters.register(EntityType.f_20457_, new AbstractHorseEntityUpdater());
        EntityUpdaters.register(EntityType.f_20560_, new AbstractHorseEntityUpdater());
        EntityUpdaters.register(EntityType.f_20503_, new AbstractHorseEntityUpdater());
        EntityUpdaters.register(EntityType.f_20549_, (player, bat) -> bat.m_27456_(!CEntity.level((Entity)player).m_8055_(player.m_142538_().m_7494_()).m_60795_()));
        EntityUpdaters.register(EntityType.f_20508_, (player, parrot) -> {
            parrot.m_6818_(player.m_142538_(), ((NearbySongAccessor)player).shape_isNearbySongPlaying());
            ((ParrotEntityAccessor)parrot).callCalculateFlapping();
            if (player.m_21187_().nextInt(400) == 0) {
                Parrot.m_29382_((Level)CEntity.level((Entity)player), (Entity)player);
            }
        });
        EntityUpdaters.register(EntityType.f_20565_, (player, dragon) -> {
            dragon.f_31082_ += 0.01f;
            dragon.f_31081_ = dragon.f_31082_;
            if (dragon.f_31093_ < 0) {
                for (int l = 0; l < dragon.f_31092_.length; ++l) {
                    dragon.f_31092_[l][0] = (double)player.m_146908_() + 180.0;
                    dragon.f_31092_[l][1] = player.m_20186_();
                }
            }
            if (++dragon.f_31093_ == dragon.f_31092_.length) {
                dragon.f_31093_ = 0;
            }
            dragon.f_31092_[dragon.f_31093_][0] = (double)player.m_146908_() + 180.0;
            dragon.f_31092_[dragon.f_31093_][1] = player.m_20186_();
        });
        EntityUpdaters.register(EntityType.f_20566_, (player, enderman) -> {
            ItemStack heldStack = player.m_21205_();
            if (heldStack.m_41720_() instanceof BlockItem) {
                enderman.m_32521_(((BlockItem)heldStack.m_41720_()).m_40614_().m_49966_());
            }
        });
        EntityUpdaters.register(EntityType.f_20558_, (player, creeper) -> ((CreeperEntityAccessor)creeper).setSwell(0));
        EntityUpdaters.register(EntityType.f_20480_, new SquidEntityUpdater());
        EntityUpdaters.register(EntityType.f_147034_, new SquidEntityUpdater());
        EntityUpdaters.register(EntityType.f_20521_, new ShulkerEntityUpdater());
        EntityUpdaters.register(EntityType.f_20555_, (player, chicken) -> {
            chicken.f_28229_ = chicken.f_28226_;
            chicken.f_28228_ = chicken.f_28227_;
            chicken.f_28227_ = chicken.f_28227_ + (CEntity.isOnGround((Entity)player) ? -1.0f : 4.0f) * 0.3f;
            chicken.f_28227_ = Mth.m_14036_((float)chicken.f_28227_, (float)0.0f, (float)1.0f);
            if (!CEntity.isOnGround((Entity)player) && chicken.f_28230_ < 1.0f) {
                chicken.f_28230_ = 1.0f;
            }
            chicken.f_28230_ *= 0.9f;
            chicken.f_28226_ += chicken.f_28230_ * 2.0f;
        });
        EntityUpdaters.register(EntityType.f_20482_, (player, strider) -> {
            BlockState blockState = CEntity.level((Entity)player).m_8055_(player.m_142538_());
            boolean bl = blockState.m_204336_(BlockTags.f_13086_) || player.m_204036_(FluidTags.f_13132_) > 0.0;
            strider.m_33951_(!bl);
        });
        EntityUpdaters.register(EntityType.f_20553_, (player, cat) -> cat.m_21837_(false));
    }
}

