/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import tocraft.craftedcore.patched.CCommandSourceStack;
import tocraft.craftedcore.patched.CEntitySummonArgument;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.Walkers;

public class EntityBlacklistCommands {
    public static LiteralCommandNode<CommandSourceStack> getRootNode() {
        Object ctx = null;
        LiteralCommandNode rootNode = Commands.m_82127_((String)"entityBlacklist").build();
        LiteralCommandNode addToList = ((LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"entity", (ArgumentType)CEntitySummonArgument.id(ctx)).suggests(SuggestionProviders.f_121645_).executes(context -> {
            EntityBlacklistCommands.addToList((CommandSourceStack)context.getSource(), CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"entity"));
            return 1;
        }))).build();
        LiteralCommandNode removeFromList = ((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"entity", (ArgumentType)CEntitySummonArgument.id(ctx)).suggests(SuggestionProviders.f_121645_).executes(context -> {
            EntityBlacklistCommands.removeFromList((CommandSourceStack)context.getSource(), CEntitySummonArgument.getEntityTypeId((CommandContext)context, (String)"entity"));
            return 1;
        }))).build();
        LiteralCommandNode listList = ((LiteralArgumentBuilder)Commands.m_82127_((String)"list").executes(context -> EntityBlacklistCommands.listEntities((CommandSourceStack)context.getSource()))).build();
        LiteralCommandNode clearList = ((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").executes(context -> EntityBlacklistCommands.clearEntities((CommandSourceStack)context.getSource()))).build();
        LiteralCommandNode isWhitelist = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"isWhitelist").executes(context -> {
            EntityBlacklistCommands.isWhitelist((CommandSourceStack)context.getSource());
            return 1;
        })).then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            EntityBlacklistCommands.setIsWhitelist((CommandSourceStack)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"value"));
            return 1;
        }))).build();
        rootNode.addChild((CommandNode)listList);
        rootNode.addChild((CommandNode)clearList);
        rootNode.addChild((CommandNode)addToList);
        rootNode.addChild((CommandNode)removeFromList);
        rootNode.addChild((CommandNode)isWhitelist);
        return rootNode;
    }

    private static void isWhitelist(CommandSourceStack source) {
        CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"craftedcore.config.get", (Object[])new Object[]{"entityBlacklistIsWhitelist", Walkers.CONFIG.entityBlacklistIsWhitelist}), (boolean)false);
    }

    private static void setIsWhitelist(CommandSourceStack source, boolean value) {
        Walkers.CONFIG.entityBlacklistIsWhitelist = value;
        Walkers.CONFIG.save();
        for (ServerPlayer player : source.m_81377_().m_6846_().m_11314_()) {
            Walkers.CONFIG.sendToPlayer(player);
        }
        CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"craftedcore.config.set", (Object[])new Object[]{"entityBlacklistIsWhitelist", String.valueOf(value)}), (boolean)false);
    }

    private static int clearEntities(CommandSourceStack source) {
        Walkers.CONFIG.entityBlacklist.clear();
        Walkers.CONFIG.save();
        for (ServerPlayer player : source.m_81377_().m_6846_().m_11314_()) {
            Walkers.CONFIG.sendToPlayer(player);
        }
        CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.entityBlacklist.clear", (Object[])new Object[0]), (boolean)false);
        return 1;
    }

    private static int listEntities(CommandSourceStack source) {
        for (String s : Walkers.CONFIG.entityBlacklist) {
            CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.entityBlacklist.list", (Object[])new Object[]{s}), (boolean)false);
        }
        if (Walkers.CONFIG.entityBlacklist.isEmpty()) {
            CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.entityBlacklist.isEmpty", (Object[])new Object[0]), (boolean)false);
        }
        return 1;
    }

    private static void addToList(CommandSourceStack source, ResourceLocation type) {
        Walkers.CONFIG.entityBlacklist.add(type.toString());
        Walkers.CONFIG.save();
        for (ServerPlayer player : source.m_81377_().m_6846_().m_11314_()) {
            Walkers.CONFIG.sendToPlayer(player);
        }
        CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.entityBlacklist.add", (Object[])new Object[]{type.toString()}), (boolean)false);
    }

    private static void removeFromList(CommandSourceStack source, ResourceLocation type) {
        Walkers.CONFIG.entityBlacklist.remove(type.toString());
        Walkers.CONFIG.save();
        for (ServerPlayer player : source.m_81377_().m_6846_().m_11314_()) {
            Walkers.CONFIG.sendToPlayer(player);
        }
        CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.entityBlacklist.remove", (Object[])new Object[]{type.toString()}), (boolean)false);
    }
}

