/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import tocraft.craftedcore.patched.CCommandSourceStack;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.Walkers;

public class PlayerBlacklistCommands {
    public static LiteralCommandNode<CommandSourceStack> getRootNode() {
        LiteralCommandNode rootNode = Commands.m_82127_((String)"playerBlacklist").build();
        LiteralCommandNode isWhitelist = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"isWhitelist").executes(context -> PlayerBlacklistCommands.isWhitelist((CommandSourceStack)context.getSource()))).then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> PlayerBlacklistCommands.setIsWhitelist((CommandSourceStack)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"value"))))).build();
        LiteralCommandNode preventUnlocking = ((LiteralArgumentBuilder)Commands.m_82127_((String)"preventUnlocking").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> PlayerBlacklistCommands.setPreventUnlocking((CommandSourceStack)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"value"))))).build();
        LiteralCommandNode preventMorphing = ((LiteralArgumentBuilder)Commands.m_82127_((String)"preventMorphing").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> PlayerBlacklistCommands.setPreventMorphing((CommandSourceStack)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"value"))))).build();
        LiteralCommandNode addToList = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(context -> {
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)context, (String)"players")) {
                PlayerBlacklistCommands.addToList((CommandSourceStack)context.getSource(), player.m_142081_());
            }
            return 1;
        }))).then(Commands.m_82129_((String)"playerUUID", (ArgumentType)UuidArgument.m_113850_()).executes(context -> {
            PlayerBlacklistCommands.addToList((CommandSourceStack)context.getSource(), UuidArgument.m_113853_((CommandContext)context, (String)"playerUUID"));
            return 1;
        }))).build();
        LiteralCommandNode removeFromList = ((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(context -> {
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)context, (String)"players")) {
                PlayerBlacklistCommands.removeFromList((CommandSourceStack)context.getSource(), player.m_142081_());
            }
            return 1;
        })).then(Commands.m_82129_((String)"playerUUID", (ArgumentType)UuidArgument.m_113850_()).executes(context -> {
            PlayerBlacklistCommands.removeFromList((CommandSourceStack)context.getSource(), UuidArgument.m_113853_((CommandContext)context, (String)"playerUUID"));
            return 1;
        })))).build();
        LiteralCommandNode listList = ((LiteralArgumentBuilder)Commands.m_82127_((String)"list").executes(context -> PlayerBlacklistCommands.listPlayers((CommandSourceStack)context.getSource()))).build();
        rootNode.addChild((CommandNode)isWhitelist);
        rootNode.addChild((CommandNode)preventUnlocking);
        rootNode.addChild((CommandNode)preventMorphing);
        rootNode.addChild((CommandNode)listList);
        rootNode.addChild((CommandNode)addToList);
        rootNode.addChild((CommandNode)removeFromList);
        return rootNode;
    }

    private static int isWhitelist(CommandSourceStack source) {
        CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.getConfigEntry", (Object[])new Object[]{"playerBlacklistIsWhitelist", Walkers.CONFIG.playerBlacklistIsWhitelist}), (boolean)false);
        return 1;
    }

    private static int setIsWhitelist(CommandSourceStack source, boolean value) {
        Walkers.CONFIG.playerBlacklistIsWhitelist = value;
        Walkers.CONFIG.save();
        for (ServerPlayer player : source.m_81377_().m_6846_().m_11314_()) {
            Walkers.CONFIG.sendToPlayer(player);
        }
        CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.setConfigEntry", (Object[])new Object[]{"playerBlacklistIsWhitelist", String.valueOf(value)}), (boolean)false);
        return 1;
    }

    private static int setPreventUnlocking(CommandSourceStack source, boolean value) {
        Walkers.CONFIG.blacklistPreventsUnlocking = value;
        Walkers.CONFIG.save();
        for (ServerPlayer player : source.m_81377_().m_6846_().m_11314_()) {
            Walkers.CONFIG.sendToPlayer(player);
        }
        CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.setConfigEntry", (Object[])new Object[]{"blacklistPreventsUnlocking", String.valueOf(value)}), (boolean)false);
        return 1;
    }

    private static int setPreventMorphing(CommandSourceStack source, boolean value) {
        Walkers.CONFIG.blacklistPreventsMorphing = value;
        Walkers.CONFIG.save();
        for (ServerPlayer player : source.m_81377_().m_6846_().m_11314_()) {
            Walkers.CONFIG.sendToPlayer(player);
        }
        CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.setConfigEntry", (Object[])new Object[]{"blacklistPreventsMorphing", String.valueOf(value)}), (boolean)false);
        return 1;
    }

    private static int listPlayers(CommandSourceStack source) {
        for (UUID uuid : Walkers.CONFIG.playerUUIDBlacklist) {
            ServerPlayer player = source.m_81377_().m_6846_().m_11259_(uuid);
            Component name = player != null ? player.m_5446_() : TComponent.literal((String)uuid.toString());
            CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.playerBlacklist.list", (Object[])new Object[]{name}), (boolean)false);
        }
        if (Walkers.CONFIG.playerUUIDBlacklist.isEmpty()) {
            CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.playerBlacklist.isEmpty", (Object[])new Object[0]), (boolean)false);
        }
        return 1;
    }

    private static void addToList(CommandSourceStack source, UUID uuid) {
        Walkers.CONFIG.playerUUIDBlacklist.add(uuid);
        Walkers.CONFIG.save();
        for (ServerPlayer player : source.m_81377_().m_6846_().m_11314_()) {
            Walkers.CONFIG.sendToPlayer(player);
        }
        ServerPlayer player = source.m_81377_().m_6846_().m_11259_(uuid);
        Component name = player != null ? player.m_5446_() : TComponent.literal((String)uuid.toString());
        CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.playerBlacklist.add", (Object[])new Object[]{name}), (boolean)false);
    }

    private static void removeFromList(CommandSourceStack source, UUID uuid) {
        Walkers.CONFIG.playerUUIDBlacklist.remove(uuid);
        Walkers.CONFIG.save();
        for (ServerPlayer player : source.m_81377_().m_6846_().m_11314_()) {
            Walkers.CONFIG.sendToPlayer(player);
        }
        ServerPlayer player = source.m_81377_().m_6846_().m_11259_(uuid);
        Component name = player != null ? player.m_5446_() : TComponent.literal((String)uuid.toString());
        CCommandSourceStack.sendSuccess((CommandSourceStack)source, (Component)TComponent.translatable((String)"walkers.playerBlacklist.remove", (Object[])new Object[]{name}), (boolean)false);
    }
}

