/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.eventhandler;

import com.mojang.serialization.DynamicOps;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ServerLevelAccessor;
import tocraft.craftedcore.event.common.EntityEvents;
import tocraft.craftedcore.event.common.PlayerEvents;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.FlightHelper;
import tocraft.walkers.api.PlayerHostility;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.CantInteractTrait;
import tocraft.walkers.traits.impl.NocturnalTrait;
import tocraft.walkers.traits.impl.RiderTrait;

public class WalkersEventHandlers {
    public static void initialize() {
        WalkersEventHandlers.registerHostilityUpdateHandler();
        WalkersEventHandlers.registerEntityRidingHandler();
        WalkersEventHandlers.registerPlayerRidingHandler();
        WalkersEventHandlers.registerLivingDeathHandler();
        EntityEvents.INTERACT_WITH_PLAYER.register((player, entity, hand) -> {
            LivingEntity shape = PlayerShape.getCurrentShape(player);
            if (shape != null) {
                for (ShapeTrait<LivingEntity> skill : TraitRegistry.get(shape, CantInteractTrait.ID)) {
                    if (((CantInteractTrait)skill).canInteractWithEntity(entity)) continue;
                    return InteractionResult.FAIL;
                }
            }
            return InteractionResult.PASS;
        });
        PlayerEvents.ALLOW_SLEEP_TIME.register((player, sleepingPos, vanillaResult) -> {
            if (TraitRegistry.has(PlayerShape.getCurrentShape(player), NocturnalTrait.ID)) {
                return CEntity.level((Entity)player).m_46461_() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        });
        PlayerEvents.SLEEP_FINISHED_TIME.register((level, newTime) -> {
            if (level.m_46461_() && !level.m_8795_(player -> player.m_5803_() && TraitRegistry.has(PlayerShape.getCurrentShape((Player)player), NocturnalTrait.ID)).isEmpty()) {
                return newTime + level.m_46468_() % 24000L > 12000L ? 13000L : -11000L;
            }
            return newTime;
        });
        PlayerEvents.AWARD_ADVANCEMENT.register((player, advancement, criterionKey) -> {
            if (Walkers.hasFlyingPermissions(player)) {
                FlightHelper.grantFlightTo(player);
                FlightHelper.updateFlyingSpeed((Player)player);
                player.m_6885_();
            }
        });
    }

    public static void registerHostilityUpdateHandler() {
        EntityEvents.INTERACT_WITH_PLAYER.register((player, entity, hand) -> {
            if (!CEntity.level((Entity)player).f_46443_ && Walkers.CONFIG.playerCanTriggerHostiles && entity instanceof Monster) {
                PlayerHostility.set(player, Walkers.CONFIG.hostilityTime);
            }
            return InteractionResult.PASS;
        });
    }

    public static void registerEntityRidingHandler() {
        EntityEvents.INTERACT_WITH_PLAYER.register((player, entity, hand) -> {
            LivingEntity shape = PlayerShape.getCurrentShape(player);
            if (shape != null && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                for (RiderTrait riderTrait : TraitRegistry.get(shape, RiderTrait.ID).stream().map(entry -> (RiderTrait)entry).toList()) {
                    Player rideablePlayer;
                    if (!riderTrait.isRideable(livingEntity) && (!(livingEntity instanceof Player) || !riderTrait.isRideable(PlayerShape.getCurrentShape(rideablePlayer = (Player)livingEntity)))) continue;
                    player.m_20329_(entity);
                    return InteractionResult.PASS;
                }
            }
            return InteractionResult.PASS;
        });
    }

    public static void registerPlayerRidingHandler() {
        EntityEvents.INTERACT_WITH_PLAYER.register((player, entity, hand) -> {
            Player playerToBeRidden;
            if (entity instanceof Player && PlayerShape.getCurrentShape(playerToBeRidden = (Player)entity) instanceof AbstractHorse) {
                player.m_7998_((Entity)playerToBeRidden, true);
            }
            return InteractionResult.PASS;
        });
    }

    public static void registerLivingDeathHandler() {
        EntityEvents.LIVING_DEATH.register((entity, damageSource) -> {
            if (!CEntity.level((Entity)entity).m_5776_() && entity instanceof Villager) {
                ZombieVillager zombievillager;
                Player player;
                Villager villager = (Villager)entity;
                Entity patt0$temp = damageSource.m_7639_();
                if (patt0$temp instanceof Player && PlayerShape.getCurrentShape(player = (Player)patt0$temp) instanceof Zombie && (CEntity.level((Entity)player).m_46791_() == Difficulty.HARD || !player.m_21187_().nextBoolean()) && (zombievillager = (ZombieVillager)villager.m_21406_(EntityType.f_20530_, false)) != null) {
                    zombievillager.m_6518_((ServerLevelAccessor)CEntity.level((Entity)player), CEntity.level((Entity)player).m_6436_(zombievillager.m_142538_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true), null);
                    zombievillager.m_34411_(villager.m_6616_().m_45388_());
                    zombievillager.m_141967_(villager.m_7141_());
                    zombievillager.m_34391_((Tag)villager.m_35517_().m_26179_((DynamicOps)NbtOps.f_128958_).getValue());
                    zombievillager.m_34373_(villager.m_7809_());
                }
            }
            return InteractionResult.PASS;
        });
    }
}

