/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin.client;

import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.util.Maths;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.model.ArmRenderingManipulator;
import tocraft.walkers.api.model.EntityArms;
import tocraft.walkers.api.model.EntityUpdater;
import tocraft.walkers.api.model.EntityUpdaters;
import tocraft.walkers.mixin.accessor.EntityAccessor;
import tocraft.walkers.mixin.accessor.LivingEntityAccessor;
import tocraft.walkers.mixin.client.accessor.LivingEntityRendererAccessor;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={PlayerRenderer.class})
public abstract class PlayerEntityRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    @Shadow
    @Contract(pure=true)
    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable HumanoidModel.ArmPose m_117794_(AbstractClientPlayer player, InteractionHand hand) {
        return null;
    }

    private PlayerEntityRendererMixin(EntityRendererProvider.Context ctx, PlayerModel<AbstractClientPlayer> model, float shadowRadius) {
        super(ctx, model, shadowRadius);
    }

    @WrapWithCondition(method={"render(Lnet/minecraft/client/player/AbstractClientPlayer;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V")})
    private boolean redirectRender(LivingEntityRenderer<AbstractClientPlayer, EntityModel<AbstractClientPlayer>> renderer, LivingEntity player, float f, float g, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)player);
        if (shape != null) {
            if (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && player.m_20202_() == Minecraft.m_91087_().f_91075_) {
                return false;
            }
            shape.f_20923_ = player.f_20923_;
            shape.f_20924_ = player.f_20924_;
            shape.f_20925_ = player.f_20925_;
            shape.f_20911_ = player.f_20911_;
            shape.f_20913_ = player.f_20913_;
            shape.f_20920_ = player.f_20920_;
            shape.f_20921_ = player.f_20921_;
            shape.f_20883_ = player.f_20883_;
            shape.f_20884_ = player.f_20884_;
            shape.f_20885_ = player.f_20885_;
            shape.f_20886_ = player.f_20886_;
            shape.f_19797_ = player.f_19797_;
            shape.f_20912_ = player.f_20912_;
            ((LivingEntityAccessor)shape).setSwimAmount(((LivingEntityAccessor)player).getSwimAmount());
            ((LivingEntityAccessor)shape).setSwimAmountO(((LivingEntityAccessor)player).getSwimAmountO());
            shape.m_6853_(CEntity.isOnGround((Entity)player));
            shape.m_20256_(player.m_20184_());
            shape.m_6842_(player.m_20177_((Player)Minecraft.m_91087_().f_91074_));
            ((EntityAccessor)shape).setVehicle(player.m_20202_());
            ((EntityAccessor)shape).setPassengers((ImmutableList<Entity>)ImmutableList.copyOf((Collection)player.m_20197_()));
            ((EntityAccessor)shape).setTouchingWater(player.m_20069_());
            if (shape instanceof Phantom) {
                shape.m_146926_(-player.m_146909_());
                shape.f_19860_ = -player.f_19860_;
            } else {
                shape.m_146926_(player.m_146909_());
                shape.f_19860_ = player.f_19860_;
            }
            if (Walkers.CONFIG.shapesEquipItems) {
                shape.m_8061_(EquipmentSlot.MAINHAND, player.m_6844_(EquipmentSlot.MAINHAND));
                shape.m_8061_(EquipmentSlot.OFFHAND, player.m_6844_(EquipmentSlot.OFFHAND));
            }
            if (Walkers.CONFIG.shapesEquipArmor) {
                shape.m_8061_(EquipmentSlot.HEAD, player.m_6844_(EquipmentSlot.HEAD));
                shape.m_8061_(EquipmentSlot.CHEST, player.m_6844_(EquipmentSlot.CHEST));
                shape.m_8061_(EquipmentSlot.LEGS, player.m_6844_(EquipmentSlot.LEGS));
                shape.m_8061_(EquipmentSlot.FEET, player.m_6844_(EquipmentSlot.FEET));
            }
            if (shape instanceof Mob) {
                ((Mob)shape).m_21561_(player.m_6117_());
            }
            shape.m_20124_(player.m_20089_());
            shape.m_6672_(player.m_7655_() == null ? InteractionHand.MAIN_HAND : player.m_7655_());
            ((LivingEntityAccessor)shape).callSetLivingEntityFlag(1, player.m_6117_());
            shape.m_21252_();
            ((LivingEntityAccessor)shape).callUpdatingUsingItem();
            shape.f_20916_ = player.f_20916_;
            EntityUpdater entityUpdater = EntityUpdaters.getUpdater(shape.m_6095_());
            if (entityUpdater != null) {
                entityUpdater.update((Player)player, shape);
            }
            if (!player.m_20177_((Player)Minecraft.m_91087_().f_91074_) && !player.m_5833_()) {
                EntityRenderer shapeRenderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)shape);
                if (shapeRenderer instanceof HumanoidMobRenderer) {
                    this.shape_setBipedShapeModelPose((AbstractClientPlayer)player, shape, (LivingEntityRenderer<?, ?>)((HumanoidMobRenderer)shapeRenderer));
                }
                shapeRenderer.m_7392_((Entity)shape, f, g, matrixStack, buffer, packedLight);
                if (player != Minecraft.m_91087_().f_91074_ && PlayerEntityRendererMixin.walkers$showName(player)) {
                    this.m_7649_((Entity)((AbstractClientPlayer)player), player.m_5446_(), matrixStack, buffer, packedLight);
                }
            }
            return false;
        }
        return true;
    }

    @Unique
    private static boolean walkers$showName(@NotNull LivingEntity player) {
        Team team = player.m_5647_();
        boolean showName = Walkers.CONFIG.showPlayerNametag;
        if (showName && team != null) {
            Team.Visibility visibility = team.m_7470_();
            Team localTeam = Minecraft.m_91087_().f_91074_.m_5647_();
            boolean sameTeam = Objects.equals(localTeam != null ? localTeam.m_5758_() : null, team.m_5758_());
            if (visibility == Team.Visibility.NEVER || sameTeam && visibility == Team.Visibility.HIDE_FOR_OWN_TEAM || !sameTeam && visibility == Team.Visibility.HIDE_FOR_OTHER_TEAMS) {
                showName = false;
            }
        }
        return showName;
    }

    @Unique
    private void shape_setBipedShapeModelPose(AbstractClientPlayer player, LivingEntity shape, LivingEntityRenderer<?, ?> shapeRenderer) {
        HumanoidModel shapeBipedModel = (HumanoidModel)shapeRenderer.m_7200_();
        if (shape.m_5833_()) {
            shapeBipedModel.m_8009_(false);
            shapeBipedModel.f_102808_.f_104207_ = true;
            shapeBipedModel.f_102809_.f_104207_ = true;
        } else {
            shapeBipedModel.m_8009_(true);
            shapeBipedModel.f_102809_.f_104207_ = player.m_36170_(PlayerModelPart.HAT);
            shapeBipedModel.f_102817_ = shape.m_6047_();
            HumanoidModel.ArmPose mainHandPose = PlayerEntityRendererMixin.m_117794_(player, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose offHandPose = PlayerEntityRendererMixin.m_117794_(player, InteractionHand.OFF_HAND);
            if (mainHandPose != null && mainHandPose.m_102897_()) {
                HumanoidModel.ArmPose armPose = offHandPose = shape.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (mainHandPose != null && offHandPose != null && shape.m_5737_() == HumanoidArm.RIGHT) {
                shapeBipedModel.f_102816_ = mainHandPose;
                shapeBipedModel.f_102815_ = offHandPose;
            } else if (mainHandPose != null && offHandPose != null) {
                shapeBipedModel.f_102816_ = offHandPose;
                shapeBipedModel.f_102815_ = mainHandPose;
            }
        }
    }

    @Inject(method={"getRenderOffset(Lnet/minecraft/client/player/AbstractClientPlayer;F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyPositionOffset(AbstractClientPlayer player, float f, CallbackInfoReturnable<Vec3> cir) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)player);
        if (shape != null && shape instanceof TamableAnimal) {
            cir.setReturnValue((Object)super.m_7860_((Entity)player, f));
        }
    }

    @Inject(method={"renderHand"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderArm(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, ModelPart arm, ModelPart sleeve, CallbackInfo ci) {
        EntityRenderer renderer;
        LivingEntity shape = PlayerShape.getCurrentShape((Player)player);
        if (shape != null && (renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)shape)) instanceof LivingEntityRenderer) {
            LivingEntityRenderer rendererCasted = (LivingEntityRenderer)renderer;
            EntityModel model = ((LivingEntityRenderer)renderer).m_7200_();
            arm = null;
            sleeve = null;
            if (model instanceof HumanoidModel) {
                arm = player.m_5737_() == HumanoidArm.RIGHT ? ((HumanoidModel)model).f_102811_ : ((HumanoidModel)model).f_102812_;
                if (model instanceof PlayerModel) {
                    sleeve = ((PlayerModel)model).f_103375_;
                }
            } else {
                Tuple<ModelPart, ArmRenderingManipulator<?>> pair = EntityArms.get(shape, model);
                if (pair != null) {
                    arm = (ModelPart)pair.m_14418_();
                    if (player.m_5737_() == HumanoidArm.LEFT) {
                        matrices.m_85845_(Maths.getDegreesQuaternion((Vector3f)Maths.POSITIVE_Y(), (float)180.0f));
                    }
                    ((ArmRenderingManipulator)pair.m_14419_()).run(matrices, model);
                    matrices.m_85837_(0.0, -0.35, 0.5);
                }
            }
            model.f_102608_ = 0.0f;
            model.m_6973_((Entity)shape, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            if (arm != null) {
                arm.f_104203_ = 0.0f;
                arm.m_104301_(matrices, vertexConsumers.m_6299_(((LivingEntityRendererAccessor)rendererCasted).callGetRenderType(shape, true, false, true)), light, OverlayTexture.f_118083_);
            }
            if (sleeve != null) {
                sleeve.f_104203_ = 0.0f;
                sleeve.m_104301_(matrices, vertexConsumers.m_6299_(((LivingEntityRendererAccessor)rendererCasted).callGetRenderType(shape, true, false, true)), light, OverlayTexture.f_118083_);
            }
            ci.cancel();
        }
    }
}

