/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin.player;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.mixin.LivingEntityMixin;
import tocraft.walkers.mixin.accessor.LivingEntityAccessor;
import tocraft.walkers.mixin.accessor.MobEntityAccessor;

@Mixin(value={Player.class})
public abstract class PlayerSoundMixin
extends LivingEntityMixin {
    @Unique
    private int shape_ambientSoundChance = 0;

    protected PlayerSoundMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"getHurtSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void getHurtSound(DamageSource source, CallbackInfoReturnable<SoundEvent> cir) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (Walkers.CONFIG.useShapeSounds && shape != null) {
            cir.setReturnValue((Object)((LivingEntityAccessor)shape).callGetHurtSound(source));
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickAmbientSounds(CallbackInfo ci) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (!CEntity.level((Entity)this).f_46443_ && Walkers.CONFIG.playAmbientSounds && shape instanceof Mob) {
            Mob mobShape = (Mob)shape;
            if (this.m_6084_() && this.f_19796_.nextInt(1000) < this.shape_ambientSoundChance++) {
                this.shape_ambientSoundChance = -mobShape.m_8100_();
                SoundEvent sound = ((MobEntityAccessor)mobShape).callGetAmbientSound();
                if (sound != null) {
                    float volume = ((LivingEntityAccessor)mobShape).callGetSoundVolume();
                    float pitch = ((LivingEntityAccessor)mobShape).callGetVoicePitch();
                    if (Walkers.CONFIG.hearSelfAmbient) {
                        CEntity.level((Entity)this).m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), sound, this.m_5720_(), volume, pitch);
                    } else {
                        CEntity.level((Entity)this).m_6263_((Player)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), sound, this.m_5720_(), volume, pitch);
                    }
                }
            }
        }
    }

    @Inject(method={"getDeathSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void getDeathSound(CallbackInfoReturnable<SoundEvent> cir) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (Walkers.CONFIG.useShapeSounds && shape != null) {
            cir.setReturnValue((Object)((LivingEntityAccessor)shape).callGetDeathSound());
        }
    }

    @Inject(method={"getFallSounds"}, at={@At(value="HEAD")}, cancellable=true)
    private void getFallSounds(CallbackInfoReturnable<LivingEntity.Fallsounds> cir) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (Walkers.CONFIG.useShapeSounds && shape != null) {
            cir.setReturnValue((Object)shape.m_196493_());
        }
    }
}

