/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.network.impl;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.blacklist.EntityBlacklist;
import tocraft.walkers.api.platform.ApiLevel;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.ClientNetworking;
import tocraft.walkers.network.NetworkHandler;

public class UnlockPackets {
    private static final String UNLOCK_KEY = "UnlockedShape";

    public static void handleUnlockSyncPacket(ModernNetworking.Context context, CompoundTag nbt) {
        if (nbt != null && ApiLevel.getCurrentLevel().canUnlock) {
            CompoundTag idTag = nbt.m_128469_(UNLOCK_KEY);
            ClientNetworking.runOrQueue(context, player -> {
                if (!idTag.m_128456_()) {
                    ((PlayerDataProvider)player).walkers$set2ndShape(ShapeType.from(idTag));
                }
            });
        }
    }

    public static void registerShapeUnlockRequestPacketHandler() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (ResourceLocation)NetworkHandler.UNLOCK_REQUEST, (context, nbt) -> {
            if (Walkers.isPlayerBlacklisted(context.getPlayer().m_142081_()) && Walkers.CONFIG.blacklistPreventsUnlocking) {
                return;
            }
            if (!ApiLevel.getCurrentLevel().canUnlock) {
                return;
            }
            boolean validType = nbt.m_128471_("valid_type");
            if (validType) {
                ResourceLocation typeId = Identifier.parse((String)nbt.m_128461_("type_id"));
                EntityType entityType = (EntityType)Walkers.getEntityTypeRegistry().m_7745_(typeId);
                int variant = nbt.m_128451_("variant");
                context.getPlayer().m_20194_().execute(() -> {
                    boolean result;
                    @Nullable ShapeType<Z> type = ShapeType.from(entityType, variant);
                    if (type != null && !EntityBlacklist.isBlacklisted(type.getEntityType()) && (Walkers.CONFIG.unlockOverridesCurrentShape || ((PlayerDataProvider)context.getPlayer()).walkers$get2ndShape() == null) && (result = PlayerShapeChanger.change2ndShape((ServerPlayer)context.getPlayer(), type))) {
                        PlayerShape.updateShapes((ServerPlayer)context.getPlayer(), type.create(CEntity.level((Entity)context.getPlayer()), context.getPlayer()));
                    }
                });
            } else {
                context.getPlayer().m_20194_().execute(() -> PlayerShape.updateShapes((ServerPlayer)context.getPlayer(), null));
            }
            context.getPlayer().m_6210_();
        });
    }

    public static void sendSyncPacket(ServerPlayer player) {
        CompoundTag compound = new CompoundTag();
        CompoundTag id = new CompoundTag();
        if (((PlayerDataProvider)player).walkers$get2ndShape() != null) {
            id = ((PlayerDataProvider)player).walkers$get2ndShape().writeCompound();
        }
        compound.m_128365_(UNLOCK_KEY, (Tag)id);
        ModernNetworking.sendToPlayer((ServerPlayer)player, (ResourceLocation)NetworkHandler.UNLOCK_SYNC, (CompoundTag)compound);
    }

    public static void sendUnlockRequest(@Nullable ShapeType<? extends LivingEntity> type) {
        CompoundTag packet = new CompoundTag();
        packet.m_128379_("valid_type", type != null);
        if (type != null) {
            packet.m_128359_("type_id", EntityType.m_20613_(type.getEntityType()).toString());
            packet.m_128405_("variant", type.getVariantData());
        }
        ModernNetworking.sendToServer((ResourceLocation)ClientNetworking.UNLOCK_REQUEST, (CompoundTag)packet);
    }
}

