/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tocraft.craftedcore.event.client.ClientPlayerEvents;
import tocraft.craftedcore.event.client.ClientTickEvents;
import tocraft.craftedcore.event.client.RenderEvents;
import tocraft.craftedcore.registration.KeyBindingRegistry;
import tocraft.walkers.ability.AbilityOverlayRenderer;
import tocraft.walkers.api.model.EntityArms;
import tocraft.walkers.api.model.EntityUpdaters;
import tocraft.walkers.api.platform.ApiLevel;
import tocraft.walkers.eventhandler.ClientRespawnHandler;
import tocraft.walkers.impl.tick.KeyPressHandler;
import tocraft.walkers.network.ClientNetworking;
import tocraft.walkers.screen.hud.OverlayEventHandler;
import tocraft.walkers.screen.hud.VariantMenu;

@OnlyIn(value=Dist.CLIENT)
public class WalkersClient {
    public static boolean isRenderingVariantsMenu = false;
    public static int variantOffset = 0;
    private final VariantMenu variantMenu = new VariantMenu();
    public static final KeyMapping UNLOCK_KEY = new KeyMapping("key.walkers_unlock", InputConstants.Type.KEYSYM, 85, "key.categories.walkers");
    public static final KeyMapping TRANSFORM_KEY = new KeyMapping("key.walkers", InputConstants.Type.KEYSYM, 71, "key.categories.walkers");
    public static final KeyMapping ABILITY_KEY = new KeyMapping("key.walkers_ability", InputConstants.Type.KEYSYM, 82, "key.categories.walkers");
    public static final KeyMapping VARIANTS_MENU_KEY = new KeyMapping("key.walkers_variants", InputConstants.Type.KEYSYM, 86, "key.categories.walkers");

    public void initialize() {
        KeyBindingRegistry.register((KeyMapping)ABILITY_KEY);
        KeyBindingRegistry.register((KeyMapping)TRANSFORM_KEY);
        KeyBindingRegistry.register((KeyMapping)UNLOCK_KEY);
        KeyBindingRegistry.register((KeyMapping)VARIANTS_MENU_KEY);
        EntityUpdaters.init();
        AbilityOverlayRenderer.register();
        EntityArms.init();
        ClientTickEvents.CLIENT_PRE.register((Object)new KeyPressHandler());
        RenderEvents.HUD_RENDERING.register((guiGraphics, tickDelta) -> this.variantMenu.render(guiGraphics));
        ClientNetworking.registerPacketHandlers();
        OverlayEventHandler.initialize();
        ClientPlayerEvents.CLIENT_PLAYER_RESPAWN.register((Object)new ClientRespawnHandler());
        ClientPlayerEvents.CLIENT_PLAYER_QUIT.register(player -> {
            if (player != null && ApiLevel.getClientLevel() != null) {
                ((ApiLevel.OnApiLevelChange)ApiLevel.ON_API_LEVEL_CHANGE_EVENT.invoke()).onApiLevelChange(ApiLevel.getClientLevel());
            }
        });
    }
}

