/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.ability.impl.generic;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.GenericShapeAbility;

public class JumpAbility<T extends LivingEntity>
extends GenericShapeAbility<T> {
    public static final ResourceLocation ID = Walkers.id("jump");
    public static final MapCodec<JumpAbility<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.stable(new JumpAbility()));

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends GenericShapeAbility<?>> codec() {
        return CODEC;
    }

    @Override
    public void onUse(Player player, T shape, Level world) {
        int level = 1 + (int)(Math.random() * 3.0);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, this.getCooldown(shape) / 2, level, true, false));
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11979_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public Item getIcon() {
        return Items.f_42651_;
    }

    @Override
    public int getDefaultCooldown() {
        return 40;
    }
}

