/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.data.variants;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.data.variants.AdvancedNBTEntries;
import tocraft.walkers.api.data.variants.NBTEntry;
import tocraft.walkers.api.variant.TypeProvider;

public class NBTTypeProvider<T extends LivingEntity>
extends TypeProvider<T> {
    public static final Codec<NBTTypeProvider<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("fallback", (Object)0).forGetter(NBTTypeProvider::getFallbackData), (App)Codec.INT.optionalFieldOf("range", (Object)-1).forGetter(NBTTypeProvider::getRange), (App)Codec.either((Codec)Codec.list(NBTEntry.CODEC), AdvancedNBTEntries.CODEC).fieldOf("nbt").forGetter(o -> o.nbtEntryList), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("names", new HashMap()).forGetter(o -> o.nameMap)).apply((Applicative)instance, instance.stable(NBTTypeProvider::new)));
    private final int fallback;
    private final int range;
    private final Either<List<NBTEntry<?>>, AdvancedNBTEntries> nbtEntryList;
    private final Map<String, String> nameMap;

    public NBTTypeProvider(int fallback, int range, Either<List<NBTEntry<?>>, AdvancedNBTEntries> nbtEntryList, Map<String, String> nameMap) {
        this.fallback = fallback;
        this.nbtEntryList = nbtEntryList;
        this.nameMap = nameMap;
        if (range >= 0 && fallback <= range) {
            this.range = range;
        } else if (nbtEntryList.left().isPresent()) {
            switch (((NBTEntry)((List)nbtEntryList.left().get()).get(0)).nbtType().toUpperCase()) {
                case "BOOL": 
                case "BOOLEAN": {
                    this.range = 1;
                    break;
                }
                default: {
                    this.range = fallback;
                    break;
                }
            }
        } else {
            this.range = nbtEntryList.right().isPresent() ? ((AdvancedNBTEntries)nbtEntryList.right().get()).highestId() : 0;
        }
    }

    @Override
    public int getVariantData(T entity) {
        List<Integer> validData;
        CompoundTag tag = new CompoundTag();
        entity.m_20223_(tag);
        ArrayList<List<Integer>> validValues = new ArrayList<List<Integer>>();
        if (this.nbtEntryList.left().isPresent()) {
            for (NBTEntry nbtEntry : (List)this.nbtEntryList.left().get()) {
                if (!tag.m_128441_(nbtEntry.nbtField())) continue;
                switch (nbtEntry.nbtType().toUpperCase()) {
                    case "BOOL": 
                    case "BOOLEAN": {
                        validValues.add(nbtEntry.getIndex(tag.m_128471_(nbtEntry.nbtField())));
                        break;
                    }
                    case "STRING": {
                        validValues.add(nbtEntry.getIndex(tag.m_128461_(nbtEntry.nbtField())));
                        break;
                    }
                    case "INT": 
                    case "INTEGER": {
                        validValues.add(nbtEntry.getIndex(tag.m_128451_(nbtEntry.nbtField())));
                    }
                }
            }
        } else if (this.nbtEntryList.right().isPresent()) {
            validValues.add(List.of(Integer.valueOf(((AdvancedNBTEntries)this.nbtEntryList.right().get()).getData(tag))));
        }
        if (!(validData = NBTTypeProvider.getValidDataValues(validValues)).isEmpty()) {
            if (validData.size() > 1) {
                Walkers.LOGGER.error("{}: found too much valid variant ids: {} for entity: {}", new Object[]{this.getClass().getSimpleName(), validData.toArray(Integer[]::new), entity.m_6095_().m_20675_()});
            }
            return validData.get(0);
        }
        Walkers.LOGGER.error("{}: No Variant for entity type {} found.", (Object)this.getClass().getSimpleName(), (Object)entity.m_6095_().m_20675_());
        return this.getFallbackData();
    }

    @NotNull
    private static List<Integer> getValidDataValues(List<List<Integer>> validValues) {
        ArrayList<Integer> validData = new ArrayList<Integer>();
        for (List<Integer> validValue : validValues) {
            for (Integer i : validValue) {
                boolean invalid = false;
                for (List<Integer> value : validValues) {
                    if (value.contains(i)) continue;
                    invalid = true;
                    break;
                }
                if (invalid || validData.contains(i)) continue;
                validData.add(i);
            }
        }
        return validData;
    }

    @Override
    public T create(EntityType<T> type, Level world, int data) {
        CompoundTag tag = new CompoundTag();
        if (this.nbtEntryList.left().isPresent()) {
            for (NBTEntry nbtEntry : (List)this.nbtEntryList.left().get()) {
                Object value = nbtEntry.getValue(data);
                if (value instanceof Integer) {
                    Integer intValue = (Integer)value;
                    tag.m_128405_(nbtEntry.nbtField(), intValue.intValue());
                    continue;
                }
                if (value instanceof String) {
                    String stringValue = (String)value;
                    tag.m_128359_(nbtEntry.nbtField(), stringValue);
                    continue;
                }
                if (value instanceof Boolean) {
                    Boolean booleanValue = (Boolean)value;
                    tag.m_128379_(nbtEntry.nbtField(), booleanValue.booleanValue());
                    continue;
                }
                if (value != null) continue;
                Walkers.LOGGER.error("{}: variant parameter for {} not found.", (Object)this.getClass().getSimpleName(), (Object)type.m_20675_());
            }
        } else if (this.nbtEntryList.right().isPresent()) {
            ((AdvancedNBTEntries)this.nbtEntryList.right().get()).fromData(tag, data);
        }
        CompoundTag compoundTag = tag.m_6426_();
        compoundTag.m_128359_("id", Objects.requireNonNull(EntityType.m_20613_(type)).toString());
        return (T)((LivingEntity)EntityType.m_20645_((CompoundTag)compoundTag, (Level)world, entity -> entity));
    }

    @Override
    public int getFallbackData() {
        return this.fallback;
    }

    @Override
    public int getRange() {
        return this.range;
    }

    @Override
    public Component modifyText(T entity, MutableComponent text) {
        if (this.nameMap.containsKey(String.valueOf(this.getVariantData(entity)))) {
            return TComponent.translatable((String)this.nameMap.get(String.valueOf(this.getVariantData(entity))), (Object[])new Object[]{text});
        }
        return text;
    }
}

