/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.model.impl;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.model.ClassArmProvider;

@OnlyIn(value=Dist.CLIENT)
public class GenericEntityArm<L extends LivingEntity, T extends EntityModel<L>>
implements ClassArmProvider<T> {
    @Nullable
    private final ModelLayerLocation modelLayerLocation;
    @NotNull
    private final String[] modelParts;
    private boolean failed = false;

    public GenericEntityArm() {
        this((ModelLayerLocation)null, "right_front_leg");
    }

    public GenericEntityArm(@NotNull ModelLayerLocation modelLayerLocation) {
        this(modelLayerLocation, "right_front_leg");
    }

    public GenericEntityArm(String ... modelParts) {
        this((ModelLayerLocation)null, modelParts);
    }

    public GenericEntityArm(@Nullable ModelLayerLocation modelLayerLocation, String ... modelParts) {
        this.modelLayerLocation = modelLayerLocation;
        this.modelParts = modelParts;
    }

    @Override
    @Nullable
    public ModelPart getArm(LivingEntity entity, T model) {
        ModelLayerLocation modelLayer = this.modelLayerLocation != null ? this.modelLayerLocation : new ModelLayerLocation(EntityType.m_20613_((EntityType)entity.m_6095_()), "main");
        try {
            ModelPart modelPart = Minecraft.m_91087_().m_167973_().m_171103_(modelLayer);
            for (String part : this.modelParts) {
                modelPart = modelPart.m_171324_(part);
            }
            return modelPart;
        }
        catch (Exception e) {
            if (!this.failed) {
                Walkers.LOGGER.error("{}: Caught an error rendering the arm for the {}.", new Object[]{GenericEntityArm.class.getSimpleName(), EntityType.m_20613_((EntityType)entity.m_6095_()), e});
                this.failed = true;
            }
            return null;
        }
    }
}

